/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.method;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapWrappedEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.method.OlapGenericObjectMethodHelper;
import crazydev.iccube.olap.eval.method.OlapJavaMethod;
import crazydev.iccube.olap.eval.method.OlapJavaMethodReflectionUtils;
import crazydev.iccube.olap.eval.method.OlapMethodCallInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapJavaMethodHelper
extends OlapGenericObjectMethodHelper {
    protected final OlapInstrLocationRange location;
    private final boolean isField;
    private final String moduleName;
    private final String methodName;
    protected GFNode[] gfArgs;

    public OlapJavaMethodHelper(OlapMethodCallInstr instr, boolean isField) {
        this.location = instr.getLocationRange();
        this.isField = isField;
        this.moduleName = instr.getModuleName();
        this.methodName = instr.getMethodName();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModulePrefix() {
        return this.moduleName + this.getCallNotation();
    }

    protected abstract String getCallNotation();

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isField() {
        return this.isField;
    }

    private boolean isNoArgMethod() {
        return this.gfArgs == null || this.gfArgs.length == 0;
    }

    @Override
    public OlapEntity execute(GFContext context, GFTupleEvaluator cache) {
        try {
            Object javaResult = this.isField() ? this.executeForField(context, cache) : (this.isNoArgMethod() ? this.executeForNoArgMethod(context, cache) : this.executeForMethod(context, cache));
            OlapEntity result = OlapJavaMethodHelper.convertJavaResultToEntity(context, cache, javaResult);
            return result;
        }
        catch (InvocationTargetException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)(this.getModuleName() + " Method Error ( " + this.getMethodName() + " )"), (Throwable)ex);
            throw new OlapEvaluationException(context, OlapErrorCode.METHOD_EXEC_ERROR, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex.getTargetException())});
        }
        catch (IllegalAccessException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)(this.getModuleName() + " Method Error ( " + this.getMethodName() + " )"), (Throwable)ex);
            throw new OlapEvaluationException(context, OlapErrorCode.METHOD_EXEC_ERROR, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
        catch (InstantiationException | NoSuchFieldException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)(this.getModuleName() + " Method Error ( " + this.getMethodName() + " )"), (Throwable)ex);
            throw new OlapEvaluationException(context, OlapErrorCode.METHOD_FIELD_UNKNOWN, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
        catch (NoSuchMethodException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)(this.getModuleName() + " Method Error ( " + this.getMethodName() + " )"), (Throwable)ex);
            throw new OlapEvaluationException(context, OlapErrorCode.METHOD_UNKNOWN, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
        catch (RuntimeException ex) {
            if (ex instanceof OlapEvaluationException) {
                throw ex;
            }
            OlapLoggers.MDX_EVALUATION.error((Object)(this.getModuleName() + " Method Error ( " + this.getMethodName() + " )"), (Throwable)ex);
            throw new OlapEvaluationException(context, OlapErrorCode.METHOD_EXEC_ERROR, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
    }

    @Nullable
    private Object executeForField(GFContext context, GFTupleEvaluator cache) throws NoSuchFieldException, IllegalAccessException {
        return this.doExecuteForField(context, cache);
    }

    @Nullable
    protected abstract Object doExecuteForField(GFContext var1, GFTupleEvaluator var2) throws NoSuchFieldException, IllegalAccessException;

    @Nullable
    private Object executeForNoArgMethod(GFContext context, GFTupleEvaluator cache) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.doExecuteForNoArgMethod(context, cache);
    }

    @Nullable
    protected abstract Object doExecuteForNoArgMethod(GFContext var1, GFTupleEvaluator var2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException;

    @Nullable
    private Object executeForMethod(GFContext context, GFTupleEvaluator cache) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.doExecuteForMethod(context, cache);
    }

    @Nullable
    protected abstract Object doExecuteForMethod(GFContext var1, GFTupleEvaluator var2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException;

    public static Object[] convertScalarEntityParamsToJavaNativeValues(OlapInstrLocationRange error, OlapJavaMethod method, OlapEntity[] params) {
        Class<Object>[] expectedTypes = method.getParamTypes();
        Object[] jParams = new Object[params.length];
        for (int idx = 0; idx < params.length; ++idx) {
            OlapEntity param = params[idx];
            try {
                jParams[idx] = param == null ? null : param.asJavaNativeValue(expectedTypes[idx]);
                continue;
            }
            catch (RuntimeException ex) {
                try {
                    OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] Java method " + method.getName() + " : param [" + idx + "] type mismatch"), (Throwable)ex);
                    String paramName = Optional.ofNullable(method.getParamName(idx)).orElse(":" + idx);
                    String actualType = param.getFriendlyTypeName();
                    String expectedType = expectedTypes[idx].getName();
                    throw new OlapEvaluationException(error, OlapErrorCode.METHOD_EXEC_PARAM_ERROR, new Serializable[]{method.getName(), paramName, expectedType, actualType, param.asString()});
                }
                catch (RuntimeException ignored) {
                    OlapEvaluationException ee;
                    if (ignored instanceof OlapEvaluationException && (ee = (OlapEvaluationException)((Object)ignored)).isCausedBy(OlapErrorCode.METHOD_EXEC_PARAM_ERROR)) {
                        throw ignored;
                    }
                    OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not retrieve the error message", (Throwable)ignored);
                    throw ex;
                }
            }
        }
        return jParams;
    }

    public static OlapEntity convertJavaResultToEntity(GFContext context, GFTupleEvaluator cache, @Nullable Object result) {
        if (result == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (result instanceof OlapEntity) {
            return (OlapEntity)result;
        }
        if (result instanceof Double || result instanceof Float) {
            return new OlapNumericEntity(((Number)result).doubleValue());
        }
        if (result instanceof Long || result instanceof Integer || result instanceof Short || result instanceof Byte) {
            return new OlapNumericEntity(((Number)result).longValue());
        }
        if (result instanceof Number) {
            return new OlapNumericEntity(((Number)result).doubleValue());
        }
        if (result instanceof Boolean) {
            return OlapBooleanEntity.value((Boolean)result);
        }
        if (result instanceof String) {
            return new OlapStringEntity((String)result);
        }
        if (result instanceof Date) {
            return new OlapDateTimeEntity((Date)result);
        }
        if (result instanceof LocalDateTime) {
            return new OlapDateTimeEntity((LocalDateTime)result);
        }
        if (result instanceof LocalDate) {
            return new OlapDateEntity((LocalDate)result);
        }
        if (result instanceof double[]) {
            return new OlapDoubleVectorEntity((double[])result);
        }
        return new OlapWrappedEntity(result);
    }

    protected Field lookupJavaField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field = OlapJavaMethodReflectionUtils.lookupField(clazz, fieldName);
        return field;
    }

    protected OlapJavaMethod lookupJavaMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        OlapJavaMethod method = OlapJavaMethodReflectionUtils.lookupMethod(clazz, methodName);
        return method;
    }

    protected <T extends OlapScalarEntity> OlapJavaMethod lookupJavaMethod(Class<?> clazz, String methodName, T[] params) throws NoSuchMethodException {
        OlapJavaMethod method = OlapJavaMethodReflectionUtils.lookupMethod(clazz, (String)methodName, params);
        return method;
    }

    @Override
    public void addGFNodes(GFNode[] gfArgs) {
        this.gfArgs = gfArgs;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer, boolean recursive) {
        for (int i = 0; i < this.gfArgs.length; ++i) {
            GFNode node = this.gfArgs[i];
            if (recursive) {
                node.forEachNode(consumer);
                continue;
            }
            consumer.accept(node);
        }
    }

    @Override
    public String toStringForDebugger() {
        return this.moduleName + "." + this.methodName + (this.isField ? "" : "(...)");
    }
}

