/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.instr;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.io.Serializable;
import java.util.List;

public class OlapInstrLocationRanges
extends OlapErrorLocation
implements Serializable {
    private static final long serialVersionUID = -3928744700390110567L;
    private final String mdx;
    private final String mdxHash;
    private List<OlapInstrLocationRange> ranges;

    public OlapInstrLocationRanges(String mdx, String mdxHash, List<OlapInstrLocationRange> ranges) {
        this.mdx = mdx;
        this.mdxHash = mdxHash;
        this.ranges = ranges;
    }

    public String mdx() {
        return this.mdx;
    }

    public String mdxHash() {
        return this.mdxHash;
    }

    public List<OlapInstrLocationRange> getRanges() {
        return this.ranges;
    }

    public int from() {
        int from = Integer.MAX_VALUE;
        for (OlapInstrLocationRange range : this.ranges) {
            if (range.from() >= from) continue;
            from = range.from();
        }
        return from;
    }

    public void updateLocationRange(int from, int to) {
        for (OlapInstrLocationRange range : this.ranges) {
            range.updateLocationRange(from, to);
        }
    }

    public String asString(CdBabylonService babylon) {
        if (this.ranges.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int idx = 0;
        while (true) {
            sb.append(String.valueOf(this.ranges.get(idx)));
            if (idx == this.ranges.size() - 1) {
                return sb.append(']').toString();
            }
            sb.append(", ");
            ++idx;
        }
    }
}

