/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.instr;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.exception.OlapErrorLocation;
import java.io.Serializable;

public class OlapInstrLocationRange
extends OlapErrorLocation
implements Serializable {
    private static final long serialVersionUID = -1725510183714318213L;
    private final String mdx;
    private final String mdxHash;
    private int from;
    private int to;
    private int lineNumber;

    public OlapInstrLocationRange(String mdx, String mdxHash, int from, int to, int lineNumber) {
        this.mdx = mdx;
        this.mdxHash = mdxHash;
        this.from = from;
        this.to = to;
        this.lineNumber = lineNumber;
    }

    public String mdx() {
        return this.mdx;
    }

    public String mdxHash() {
        return this.mdxHash;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public void updateLocationRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public String asString(CdBabylonService babylon) {
        return "line:" + this.lineNumber;
    }

    public String asString() {
        return this.mdx.substring(this.safeFrom(this.from), this.safeTo(this.to + 1));
    }

    private int safeFrom(int index) {
        return Math.min(index, this.mdx.length());
    }

    private int safeTo(int index) {
        return Math.min(index, this.mdx.length());
    }
}

