/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.instr;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.IOlapExecutionContext;
import crazydev.iccube.olap.eval.select.context.MdxHousekeeper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapInstrExecutionContext
implements IOlapEvaluationExceptionContext,
IOlapExecutionContext {
    private final List<MdxHousekeeper> housekeepers = new ArrayList<MdxHousekeeper>();
    protected OlapInstr currentInstruction;
    private boolean forPhaseI;
    private boolean forTidyEvaluation;

    protected OlapInstrExecutionContext() {
    }

    @Override
    public IOlapEvaluationExceptionContext asExceptionContext() {
        return this;
    }

    public abstract String getUsage();

    protected void clearCurrentInstruction() {
        this.currentInstruction = null;
    }

    public OlapInstr pushCurrentInstruction(OlapInstr instr) {
        OlapInstr prev = this.currentInstruction;
        this.currentInstruction = instr;
        return prev;
    }

    public void popCurrentInstruction(OlapInstr instr) {
        this.currentInstruction = instr;
    }

    @Nullable
    public OlapInstr peekCurrentInstruction() {
        return this.currentInstruction;
    }

    public boolean isConstrained() {
        return false;
    }

    public <T> T onConstrainedViolation() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Nullable
    public abstract OlapInstrExecListener getInstrExecListener();

    @Override
    @Nullable
    public OlapInstrLocationRange getErrorLocation() {
        OlapInstr instr = this.peekCurrentInstruction();
        if (instr != null) {
            return instr.getLocationRange();
        }
        return null;
    }

    @Override
    public IOlapEvaluationExceptionContext snapshotForError() {
        IOlapEvaluationExceptionContext snapshot = IOlapEvaluationExceptionContext.snapshotForError(this);
        return snapshot;
    }

    public final String toString() {
        return this.getUsage();
    }

    @Override
    public abstract OlapNameContext getNameContext();

    @Override
    public boolean isDimensionalityCheck() {
        return true;
    }

    public void setIsForPhaseI(boolean forPhaseI) {
        this.forPhaseI = forPhaseI;
    }

    public boolean isForPhaseI() {
        return this.forPhaseI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHousekeeper(MdxHousekeeper housekeeper) {
        List<MdxHousekeeper> list = this.housekeepers;
        synchronized (list) {
            this.housekeepers.add(housekeeper);
        }
    }

    public void performHousekeeping() {
        try {
            for (MdxHousekeeper housekeeper : this.housekeepers) {
                try {
                    housekeeper.housekeeping();
                }
                catch (Exception ex) {
                    OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] housekeeping error", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] housekeeping(s) error", (Throwable)ex);
        }
    }
}

