/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.instr;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactory;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorNode;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapFactlessCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapRegularCategoryMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrExecutionContext;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryHierarchyEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateMeasureEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapDynamicCategoryMemberFormulaEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapLookupCategoryMemberAnchorEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapStaticCategoryMemberFormulaEvaluationContext;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapInstr<CTXT extends OlapInstrExecutionContext> {
    private final OlapInstrLocationRange range;
    @Nullable
    private OlapInstr parent;

    protected OlapInstr(OlapInstrLocationRange range) {
        this.range = range;
    }

    public boolean isSubCubeXyz() {
        return false;
    }

    public static <T> T onInstrExecutionError(IOlapEvaluationExceptionContext context, OlapErrorCode errorCode, Serializable ... params) {
        throw new OlapEvaluationException(context, errorCode, params);
    }

    public static OlapCalculatedMember createCalcMember(OlapCreateCalcMemberEvaluationContext context, boolean definedAtSelectStatementLevel, long declarationOrder, OlapInstrLocationRange idRange, OlapEntityIdentifier anchorId, String name, OlapInstr formula, OlapCellProperties properties, @Nullable String definedUniqueName) {
        OlapCalculatedMember calcMember = OlapInstr.doCreateCalcMember(context, definedAtSelectStatementLevel, declarationOrder, idRange, anchorId, name, formula, properties, definedUniqueName);
        List<OlapEntityIdentifier> measureOrMeasureGroupNames = properties.getNonEmptyBehavior();
        if (measureOrMeasureGroupNames != null && !measureOrMeasureGroupNames.isEmpty()) {
            for (OlapEntityIdentifier measureOrMeasureGroupName : measureOrMeasureGroupNames) {
                if (!OlapInstr.isOne(measureOrMeasureGroupName)) continue;
                calcMember.setDefinedNonEmptyBehavior(S_NonEmptyBehavior.one());
                return calcMember;
            }
            ArrayList<S_NonEmptyBehaviorNode> neFacts = new ArrayList<S_NonEmptyBehaviorNode>();
            for (OlapEntityIdentifier measureOrMeasureGroupName : measureOrMeasureGroupNames) {
                S_NonEmptyBehaviorNode facts = OlapInstr.resolveMeasureOrMeasureGroupForNEB(context, measureOrMeasureGroupName);
                if (facts == null) {
                    return (OlapCalculatedMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEMBER_NON_EMPTY_BEHAVIOR_UNKNOWN_MEASURE_GROUP, new Serializable[]{name, measureOrMeasureGroupName.asMdxString(), OlapInstr.measureGroupNames(context)});
                }
                neFacts.add(facts);
            }
            calcMember.setDefinedNonEmptyBehavior(S_NonEmptyBehaviorFactory.createForCellProperties(neFacts));
        }
        return calcMember;
    }

    private static boolean isOne(OlapEntityIdentifier measureOrMeasureGroupName) {
        String one = S_NonEmptyBehavior.one().asMdxResult().value();
        if (measureOrMeasureGroupName.getPartCount() == 1) {
            String name = measureOrMeasureGroupName.getLastPartAsName();
            return one.equals(name);
        }
        return false;
    }

    @Nullable
    private static S_NonEmptyBehaviorNode resolveMeasureOrMeasureGroupForNEB(OlapCreateCalcMemberEvaluationContext context, OlapEntityIdentifier measureOrMeasureGroupName) {
        OlapNonScalarEntity entity = context.lookupEntityByMdxIdentifier(context.getNameContext(), OlapMdxEntityLookupKinds.CUBE_ENTITY, measureOrMeasureGroupName);
        if (entity instanceof OlapMeasureMember) {
            OlapMeasureMember measure = (OlapMeasureMember)entity;
            String group = measure.getMeasureGroupName();
            OlapCube cube = measure.getCube();
            OlapFactCubeManager factManager = cube.getNullableCubeFactManager();
            if (factManager != null) {
                OlapFactMeasureGroupBaseManager resolved = factManager.getFactManager(group);
                return new S_NonEmptyBehaviorNode(resolved, measure);
            }
        }
        return OlapInstr.resolveMeasureGroupForNEB(context, measureOrMeasureGroupName);
    }

    @Nullable
    private static S_NonEmptyBehaviorNode resolveMeasureGroupForNEB(OlapCreateCalcMemberEvaluationContext context, OlapEntityIdentifier measureOrMeasureGroupName) {
        OlapFactCubeManager fm;
        OlapCube cube;
        if (measureOrMeasureGroupName.isKey()) {
            return null;
        }
        OlapSchema schema = context.getSchema();
        if (measureOrMeasureGroupName.getPartCount() == 1) {
            List<OlapCube> cubes = schema.getCubes(context.getSchemaPermissions());
            for (OlapCube cube2 : cubes) {
                OlapFactMeasureGroupBaseManager facts;
                OlapFactCubeManager fm2 = cube2.getNullableCubeFactManager();
                if (fm2 == null || (facts = fm2.getFactManager(measureOrMeasureGroupName.getLastPartAsName())) == null) continue;
                return new S_NonEmptyBehaviorNode(facts);
            }
        }
        if (measureOrMeasureGroupName.getPartCount() == 2 && (cube = schema.lookupCubeByName(context.getSchemaPermissions(), context.getNameContext(), measureOrMeasureGroupName.getPartAsName(0))) != null && (fm = cube.getNullableCubeFactManager()) != null) {
            OlapFactMeasureGroupBaseManager facts = fm.getFactManager(measureOrMeasureGroupName.getLastPartAsName());
            return new S_NonEmptyBehaviorNode(facts);
        }
        return null;
    }

    private static String measureGroupNames(OlapCreateCalcMemberEvaluationContext context) {
        OlapSchema schema = context.getSchema();
        List<OlapCube> cubes = schema.getCubes(context.getSchemaPermissions());
        boolean singleCube = cubes.size() == 1;
        StringBuilder sb = new StringBuilder();
        for (OlapCube cube : cubes) {
            OlapFactCubeManager fm = cube.getNullableCubeFactManager();
            if (fm == null) continue;
            for (OlapFactMeasureGroupBaseManager facts : fm.getFactManagers()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (!singleCube) {
                    sb.append("[").append(cube.getNameX()).append("].");
                }
                sb.append("[").append(CdMdxUtils.escape((String)facts.getMeasureGroupName())).append("]");
            }
        }
        return sb.toString();
    }

    private static OlapCalculatedMember doCreateCalcMember(OlapCreateCalcMemberEvaluationContext context, boolean definedAtSelectStatementLevel, long declarationOrder, OlapInstrLocationRange idRange, OlapEntityIdentifier anchorId, String name, OlapInstr formula, OlapCellProperties properties, @Nullable String definedUniqueName) {
        OlapNonScalarEntity anchor = context.lookupEntityByMdxIdentifier(context.getNameContext(), OlapMdxEntityLookupKinds.ALL_BUT_SET, anchorId);
        if (anchor.isMdxNull() || anchor.isFilteredOut()) {
            return (OlapCalculatedMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEMBER_MISSING_ENTITY, new Serializable[]{name, anchorId.asString()});
        }
        if (anchor instanceof OlapDimension) {
            OlapDimension danchor = (OlapDimension)anchor;
            if (danchor.isMeasures()) {
                OlapMeasuresDimension manchor = (OlapMeasuresDimension)danchor;
                OlapLevel lanchor = manchor.getLevel();
                OlapInstr.assertNotOverwritingExistingMember(context, lanchor, name);
                return OlapMemberFactory.createOlapCalculatedMember(context, definedAtSelectStatementLevel, declarationOrder, name, lanchor, idRange, formula, properties, definedUniqueName);
            }
            if (danchor.isSingleHierarchy(context.getDimensionsPermissions())) {
                OlapHierarchy hanchor = danchor.getSingleHierarchy(context.getDimensionsPermissions());
                OlapLevel lanchor = hanchor.getFirstLevel();
                OlapInstr.assertNotOverwritingExistingMember(context, lanchor, name);
                return OlapMemberFactory.createOlapCalculatedMember(context, definedAtSelectStatementLevel, declarationOrder, name, lanchor, idRange, formula, properties, definedUniqueName);
            }
        } else {
            if (anchor instanceof OlapHierarchy) {
                OlapHierarchy hanchor = (OlapHierarchy)anchor;
                OlapLevel lanchor = hanchor.getFirstLevel();
                OlapInstr.assertNotOverwritingExistingMember(context, lanchor, name);
                return OlapMemberFactory.createOlapCalculatedMember(context, definedAtSelectStatementLevel, declarationOrder, name, lanchor, idRange, formula, properties, definedUniqueName);
            }
            if (anchor instanceof OlapLevel) {
                OlapLevel lanchor = (OlapLevel)anchor;
                OlapInstr.assertNotOverwritingExistingMember(context, lanchor, name);
                if (lanchor.getDepth() != 0) {
                    OlapNameContext nameContext = context.getNameContext();
                    OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEMBER_ORPHAN, new Serializable[]{name, lanchor.getUniqueName(nameContext)});
                }
                return OlapMemberFactory.createOlapCalculatedMember(context, definedAtSelectStatementLevel, declarationOrder, name, lanchor, idRange, formula, properties, definedUniqueName);
            }
            if (anchor instanceof OlapMember) {
                OlapMember manchor = (OlapMember)anchor;
                if (manchor.getLevel().isLast()) {
                    if (!manchor.getDimension().isFactIndexing() && context.isGlobalContext()) {
                        int depth = manchor.getLevel().getDepth() + 1;
                        OlapLevel newLevel = new OlapLevel(manchor.getHierarchy(), "Level-" + depth, null, depth, null, false, true, true, false);
                        manchor.getHierarchy().addLevel(newLevel);
                    } else {
                        OlapNameContext nameContext = context.getNameContext();
                        return (OlapCalculatedMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEMBER_LAST_LEVEL, new Serializable[]{name, manchor.getUniqueName(nameContext)});
                    }
                }
                OlapInstr.assertNotOverwritingExistingMember(context, manchor, name);
                OlapCalculatedMember calcMember = OlapMemberFactory.createOlapCalculatedMember(context, definedAtSelectStatementLevel, declarationOrder, name, manchor, idRange, formula, properties, definedUniqueName);
                return calcMember;
            }
        }
        return (OlapCalculatedMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEMBER_ANCHOR_TYPE, new Serializable[]{name, anchorId.asString(), anchor.getFriendlyTypeName()});
    }

    private static void assertNotOverwritingExistingMember(OlapCreateCalcMemberEvaluationContext context, OlapMember member, String name) {
        OlapNameContext nameContext = context.getNameContext();
        OlapMember existingMember = member.unfilteredLookupMemberByName(nameContext, name);
        OlapInstr.assertNullExistingMember(context, existingMember, name);
    }

    private static void assertNotOverwritingExistingMember(OlapCreateCalcMemberEvaluationContext context, OlapLevel level, String name) {
        OlapNameContext nameContext = context.getNameContext();
        OlapMember existingMember = level.unfilteredLookupMemberByName(nameContext, name);
        OlapInstr.assertNullExistingMember(context, existingMember, name);
    }

    private static void assertNullExistingMember(OlapCreateCalcMemberEvaluationContext context, @Nullable OlapMember existingMember, String name) {
        if (existingMember != null) {
            OlapNameContext nameContext = context.getNameContext();
            OlapInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEMBER_OVERWRITE_MEMBER, new Serializable[]{name, existingMember.getUniqueName(nameContext)});
        }
    }

    public abstract String typeForError();

    @Nullable
    public OlapInstr getParent() {
        return this.parent;
    }

    public void setParent(OlapInstr parent) {
        if (this.parent != null) {
            throw new CdProgrammingException("Parent [" + this.parent.getClass().getName() + "] setup already!");
        }
        this.parent = parent;
    }

    public void detachFromParent() {
        if (this.parent == null) {
            throw new CdProgrammingException("No parent available in [" + this.getClass().getName() + "]!");
        }
        this.parent = null;
    }

    public abstract void accept(OlapInstrVisitor var1);

    public OlapInstrLocationRange getLocationRange() {
        return this.range;
    }

    public final OlapPreparedInstr prepare(IOlapPrepareContext context) {
        OlapInstrExecListener listener = context.getInstrExecListener();
        if (listener != null) {
            OlapPreparedInstr pInstr = this.doPrepareAndListen(context, listener);
            return pInstr;
        }
        OlapPreparedInstr pInstr = this.doPrepare(context);
        return pInstr;
    }

    private OlapPreparedInstr doPrepareAndListen(IOlapPrepareContext context, OlapInstrExecListener listener) {
        listener.beginInstrPrepare(this);
        try {
            OlapPreparedInstr pInstr = this.doPrepare(context);
            listener.endInstrPrepare(this, pInstr);
            return pInstr;
        }
        catch (RuntimeException ex) {
            listener.endInstrPrepareOnError(this, ex);
            throw ex;
        }
    }

    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        throw new RuntimeException("internal error: " + this.getClass().getSimpleName() + " :prepare not implemented!");
    }

    public abstract boolean isExecutedWithPreparedInstr();

    public final OlapEntity executeWithHousekeeping(CTXT context) {
        try {
            OlapEntity olapEntity = this.execute(context);
            return olapEntity;
        }
        finally {
            ((OlapInstrExecutionContext)context).performHousekeeping();
        }
    }

    public final OlapEntity execute(CTXT context) {
        OlapEntity res = this.isExecutedWithPreparedInstr() ? this.executeWithPreparedInstr(context, false) : this.executeWithoutPreparedInstr(context);
        return res;
    }

    private OlapEntity executeWithPreparedInstr(CTXT context, boolean markedForValueEvaluation) {
        GFContext gContext = ((OlapEvaluationContext)context).createGFContext();
        IOlapPrepareContext pContext = gContext.getPrepareContext();
        OlapPreparedInstr prepared = this.prepare(pContext);
        OlapEntity res = prepared.eval(gContext, markedForValueEvaluation);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapEntity executeWithoutPreparedInstr(CTXT context) {
        OlapInstr prev = ((OlapInstrExecutionContext)context).pushCurrentInstruction(this);
        try {
            OlapInstrExecListener listener = ((OlapInstrExecutionContext)context).getInstrExecListener();
            if (listener != null) {
                OlapEntity olapEntity = this.executeWithoutPreparedInstrAndListen(context, listener);
                return olapEntity;
            }
            OlapEntity olapEntity = this.doExecuteWithoutPreparedInstr(context);
            return olapEntity;
        }
        finally {
            ((OlapInstrExecutionContext)context).popCurrentInstruction(prev);
        }
    }

    private OlapEntity executeWithoutPreparedInstrAndListen(CTXT context, OlapInstrExecListener listener) {
        listener.beginInstrExecute(this);
        try {
            OlapEntity entity = this.doExecuteWithoutPreparedInstr(context);
            listener.endInstrExecute(this, entity);
            return entity;
        }
        catch (RuntimeException ex) {
            listener.endInstrExecuteOnError(this, ex);
            throw ex;
        }
    }

    private OlapEntity doExecuteWithoutPreparedInstr(CTXT context) {
        context.assertNotCancelling("instr-execute");
        if (this.isConstrainedEnabled() && ((OlapInstrExecutionContext)context).isConstrained()) {
            ((OlapInstrExecutionContext)context).onConstrainedViolation();
        }
        OlapEntity entity = this.doExecute(context);
        return entity;
    }

    protected OlapEntity doExecute(CTXT context) {
        throw new RuntimeException("internal error: inconsistent instr. processing [" + this.getClass().getSimpleName() + "]");
    }

    public boolean isConstrainedEnabled() {
        return true;
    }

    protected <T> T onInstrExecutionError(IOlapEvaluationExceptionContext context, CdMdxErrorCode errorCode, Serializable ... params) {
        OlapError<OlapInstrLocationRange, CdMdxErrorCode> error = new OlapError<OlapInstrLocationRange, CdMdxErrorCode>(context.getErrorLocation(), errorCode, params);
        throw new OlapEvaluationException(error);
    }

    protected <T> T onInstrExecutionTypeMismatchError(IOlapEvaluationExceptionContext context, String expectedType, String actualType) {
        throw new OlapEvaluationException(context, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{expectedType, actualType});
    }

    public boolean isNull() {
        return false;
    }

    public boolean isMissingFunctionArgument() {
        return false;
    }

    public abstract String toStringForDebugger();

    public boolean isWorthProfiling() {
        return false;
    }

    public String getMdx() {
        OlapInstrLocationRange range = this.getLocationRange();
        return range.asString();
    }

    public String getMdxForDrillthrough() {
        OlapInstrLocationRange range = this.getLocationRange();
        return range.asString();
    }

    protected OlapDimension lookupCategoryDimension(OlapMdxStatementExecutionContext context, OlapEntityIdentifier id) {
        OlapEntityIdentifier dimensionId = id.subIdentifier(0, 1);
        OlapFactlessCube cube = new OlapFactlessCube(this.getLocationRange(), "create-category-hierarchy-", context.getSchema());
        OlapCreateCategoryHierarchyEvaluationContext evalContext = new OlapCreateCategoryHierarchyEvaluationContext(new OlapMdxStatementWithCubeSelectExecutionContext(context.getRequestContext(), context.getRequestProperties(), context.getAnnotations(), context.getInstrExecListener(), context.getSchema(), cube, true));
        OlapNonScalarEntity entity = evalContext.lookupEntityByMdxIdentifier(evalContext.getNameContext(), OlapMdxEntityLookupKinds.CUBE_ENTITY, dimensionId);
        if (entity.isMdxNull() || entity.isFilteredOut()) {
            throw new OlapEvaluationException(context, OlapErrorCode.CAT_HIERARCHY_DIMENSION_UNKNOWN, new Serializable[]{dimensionId.asString()});
        }
        if (entity instanceof OlapDimension) {
            OlapDimension dimension = (OlapDimension)entity;
            return dimension;
        }
        throw new OlapEvaluationException(context, OlapErrorCode.CAT_HIERARCHY_DIMENSION_MISMATCH, new Serializable[]{dimensionId.asString(), entity.getFriendlyTypeName()});
    }

    protected String getCategoryHierarchyName(IOlapEvaluationExceptionContext errorContext, OlapEntityIdentifier id) {
        OlapEntityIdentifier hierarchyId = id.subIdentifier(1, 2);
        String hierarchyName = hierarchyId.asSingleRegularName();
        if (hierarchyName == null) {
            throw new OlapEvaluationException(errorContext, OlapErrorCode.CAT_HIERARCHY_NAME_INVALID, new Serializable[]{id.asString()});
        }
        return hierarchyName;
    }

    protected OlapAbstractCategoryMember createCategoryMember(OlapMdxStatementExecutionContext context, OlapHierarchyScope scope, OlapEntityIdentifier id, boolean dynamicEvaluation, OlapInstr formula, OlapCategoryMemberProperties properties) {
        String name = id.getLastPartAsName();
        OlapMember parent = this.lookupParentMember(context, scope, id, name);
        return new OlapRegularCategoryMember(context, this, scope, id, dynamicEvaluation, formula, properties, parent, name);
    }

    private OlapMember lookupParentMember(OlapMdxStatementExecutionContext context, OlapHierarchyScope scope, OlapEntityIdentifier id, String name) {
        OlapLookupCategoryMemberAnchorEvaluationContext evalContext;
        if (context instanceof OlapMdxStatementWithCubeSelectExecutionContext) {
            evalContext = new OlapLookupCategoryMemberAnchorEvaluationContext(context);
        } else {
            OlapFactlessCube cube = new OlapFactlessCube(this.getLocationRange(), "create-category-member-", context.getSchema());
            evalContext = new OlapLookupCategoryMemberAnchorEvaluationContext(new OlapMdxStatementWithCubeSelectExecutionContext(context.getRequestContext(), context.getRequestProperties(), context.getAnnotations(), context.getInstrExecListener(), context.getSchema(), cube, true));
        }
        return this.doLookupParentMember(evalContext, scope, id, name);
    }

    private OlapMember doLookupParentMember(OlapLookupCategoryMemberAnchorEvaluationContext context, OlapHierarchyScope scope, OlapEntityIdentifier id, String name) {
        OlapEntityIdentifier anchorId = id.subIdentifier(0, id.getPartCount() - 1);
        OlapNonScalarEntity anchor = context.lookupEntityByMdxIdentifier(context.getNameContext(), OlapMdxEntityLookupKinds.ALL_BUT_SET, anchorId);
        if (anchor.isMdxNull() || anchor.isFilteredOut()) {
            return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_MEMBER_ANCHOR_MISSING, new Serializable[]{id.asString()});
        }
        if (anchor instanceof OlapMember) {
            OlapMember child;
            OlapMember mAnchor = (OlapMember)anchor;
            OlapHierarchy hierarchy = mAnchor.getHierarchy();
            switch (scope) {
                case SCHEMA: {
                    if (hierarchy.isSchemaBased()) break;
                    return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_HIERARCHY_MISMATCH, new Serializable[]{id.asString(), hierarchy.getScope(), OlapHierarchyScope.SCHEMA});
                }
                case SESSION: {
                    if (hierarchy.isSessionBased()) break;
                    return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_HIERARCHY_MISMATCH, new Serializable[]{id.asString(), hierarchy.getScope(), OlapHierarchyScope.SESSION});
                }
                case REQUEST: {
                    if (hierarchy.isRequestBased()) break;
                    return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_HIERARCHY_MISMATCH, new Serializable[]{id.asString(), hierarchy.getScope(), OlapHierarchyScope.REQUEST});
                }
                default: {
                    throw new RuntimeException("internal error : unknown category member scope [" + String.valueOf((Object)scope) + "]");
                }
            }
            if (mAnchor.isCalculated()) {
                return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_MEMBER_ANCHOR_INVALID_CALC_MEMBER, new Serializable[]{id.asString()});
            }
            if (!mAnchor.getHierarchy().acceptCategoryMembers()) {
                return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_MEMBER_ANCHOR_INVALID_HIERARCHY, new Serializable[]{id.asString()});
            }
            OlapMemberFilter tupleFilter = context.getMemberFilter();
            OlapIterator<OlapMember> children = mAnchor.getChildren(tupleFilter);
            children.reset();
            while ((child = children.next()) != null) {
                if (!child.getNameX().equalsIgnoreCase(name)) continue;
                return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_MEMBER_OVERWRITE_MEMBER, new Serializable[]{id.asString()});
            }
            return mAnchor;
        }
        return (OlapMember)OlapInstr.onInstrExecutionError(context, OlapErrorCode.CAT_MEMBER_ANCHOR_INVALID_TYPE, new Serializable[]{id.asString(), anchor.getFriendlyTypeName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateCategoryMemberFormula(OlapMdxStatementExecutionContext context, OlapHierarchyScope scope, OlapEntityIdentifier id, boolean dynamicEvaluation, OlapInstr formula) {
        Object object;
        S_MdxStatementRequestContextRef clusterContextRef;
        block8: {
            OlapMdxStatementExecutionContext sContext;
            OlapEvaluationContext evalContext;
            clusterContextRef = null;
            if (dynamicEvaluation) {
                evalContext = this.setupCategoryMemberFormulaDynamicEvaluationContext(context, scope);
            } else {
                evalContext = this.setupCategoryMemberFormulaStaticEvaluationContext(context, scope);
                OlapMdxStatementExecutionContext sContext2 = evalContext.getStatementExecutionContext();
                clusterContextRef = sContext2.createClusterContext();
                sContext2.createClusterStaticContext();
            }
            try {
                Object res;
                object = res = this.doEvaluateFormula(evalContext, id, formula);
                if (dynamicEvaluation) break block8;
                sContext = evalContext.getStatementExecutionContext();
            }
            catch (Throwable throwable) {
                try {
                    if (!dynamicEvaluation) {
                        OlapMdxStatementExecutionContext sContext3 = evalContext.getStatementExecutionContext();
                        sContext3.performHousekeeping();
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    context.deleteClusterContext(clusterContextRef);
                    throw throwable2;
                }
            }
            sContext.performHousekeeping();
        }
        context.deleteClusterContext(clusterContextRef);
        return object;
    }

    protected OlapEvaluationContext setupCategoryMemberFormulaStaticEvaluationContext(OlapMdxStatementExecutionContext sContext, OlapHierarchyScope scope) {
        OlapSchema schema;
        OlapCube cube = sContext instanceof OlapMdxStatementWithCubeSelectExecutionContext ? sContext.getCube().getUnderlying() : ((schema = sContext.getSchema()).getCubeCount() > 0 ? schema.getFirstCube() : new OlapFactlessCube(this.getLocationRange(), "eval-category-static-member-", schema));
        OlapProperties requestProperties = scope == OlapHierarchyScope.SCHEMA ? sContext.getRequestContext().getOlapEngineProperties() : sContext.getRequestProperties();
        OlapMdxStatementWithCubeSelectExecutionContext statementContext = new OlapMdxStatementWithCubeSelectExecutionContext(sContext.getRequestContext(), requestProperties, sContext.getAnnotations(), sContext.getInstrExecListener(), sContext.getSchema(), cube, true);
        statementContext.adoptMdxExtraExecutionLOCK(sContext);
        return new OlapStaticCategoryMemberFormulaEvaluationContext((OlapMdxStatementExecutionContext)statementContext, cube);
    }

    protected OlapEvaluationContext setupCategoryMemberFormulaDynamicEvaluationContext(OlapMdxStatementExecutionContext scontext, OlapHierarchyScope scope) {
        OlapCube cube = scontext.getCube();
        return new OlapDynamicCategoryMemberFormulaEvaluationContext(scontext, cube);
    }

    private Object doEvaluateFormula(OlapEvaluationContext evalContext, OlapEntityIdentifier id, OlapInstr formula) {
        OlapEntity entity = formula.execute(evalContext);
        if (entity instanceof OlapTupleSet) {
            return this.formulaAsSet(evalContext, id, formula, (OlapTupleSet)entity);
        }
        if (entity instanceof OlapTuple) {
            return this.formulaAsSet(evalContext, id, formula, OlapSetFactory.instance((OlapTuple[])new OlapTuple[]{(OlapTuple)entity}));
        }
        if (entity instanceof OlapSubCubeEntity) {
            return this.formulaAsSubCube(evalContext, id, formula, (OlapSubCubeEntity)entity);
        }
        return OlapInstr.onInstrExecutionError(evalContext, OlapErrorCode.CAT_MEMBER_TUPLES_INVALID, new Serializable[]{id.asString(), entity.getFriendlyTypeName()});
    }

    private OlapIterator<? extends OlapTuple> formulaAsSet(OlapEvaluationContext evalContext, OlapEntityIdentifier id, OlapInstr formula, OlapTupleSet res) {
        OlapTuple tuple;
        OlapIterator tuples = res.getIterator(true);
        boolean isEmpty = true;
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            isEmpty = false;
            int count = tuple.getMemberCount();
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = tuple.getMember(ii);
                if (!member.isCalculated() && !member.isMeasure()) continue;
                return (OlapIterator)OlapInstr.onInstrExecutionError(evalContext, OlapErrorCode.CAT_MEMBER_WITH_CALC_MEMBER, new Serializable[]{id.asString(), ONames.uname4Log(member)});
            }
        }
        return tuples;
    }

    private OlapSubCubeEntity formulaAsSubCube(OlapEvaluationContext evalContext, OlapEntityIdentifier id, OlapInstr formula, OlapSubCubeEntity res) {
        return res;
    }

    public IOlapEvaluationExceptionContext createErrorContext(final Locale locale, final OlapNameContext nameContext, final boolean dimensionalityCheck) {
        return new IOlapEvaluationExceptionContext(){
            final /* synthetic */ OlapInstr this$0;
            {
                OlapInstr olapInstr = this$0;
                Objects.requireNonNull(olapInstr);
                this.this$0 = olapInstr;
            }

            @Override
            public Locale getLocale() {
                return locale;
            }

            @Override
            public OlapNameContext getNameContext() {
                return nameContext;
            }

            @Override
            public OlapInstrLocationRange getErrorLocation() {
                return this.this$0.getLocationRange();
            }

            @Override
            public IOlapEvaluationExceptionContext snapshotForError() {
                return this;
            }

            @Override
            public boolean isDimensionalityCheck() {
                return dimensionalityCheck;
            }
        };
    }

    public OlapUserMeasureMember createUserMeasure(OlapCreateMeasureEvaluationContext context, @Nullable OlapHierarchy defaultTimeHierarchy, OlapCube cube, boolean definedAtSelectStatementLevel, String measureName, OlapInstr formula, OlapCellProperties properties) {
        OlapHierarchy rollupHierarchy;
        OlapLevel level = cube.getMeasuresDimension().getLevel();
        List<OlapMeasureMember> refMeasures = this.evalRefMeasures(context, measureName, formula);
        IOlapBuilderBaseFactsDef measureGroup = this.assertSingleMeasureGroup(context, measureName, refMeasures);
        OlapAggregationType hierarchyAggregationType = properties.getAggregationType();
        if (hierarchyAggregationType == null) {
            if (refMeasures.size() == 1) {
                hierarchyAggregationType = refMeasures.get(0).getHierarchyAggregationType();
            } else {
                throw new OlapEvaluationException(context, OlapErrorCode.MEASURE_FORMULA_MISSING_AGGREGATION, new Serializable[]{measureName});
            }
        }
        if (hierarchyAggregationType.isRollupHierarchyRequired()) {
            rollupHierarchy = defaultTimeHierarchy;
            if (rollupHierarchy == null) {
                throw new OlapEvaluationException(context, OlapErrorCode.INVALID_AGGREGATION_TYPE, new Serializable[]{hierarchyAggregationType, measureName});
            }
        } else {
            rollupHierarchy = null;
        }
        OlapInstr.inheritFormatString(properties, refMeasures);
        OlapInstr.inheritEmptyIsZero(properties, refMeasures);
        boolean emptyIsZero = properties.isEmptyIsZero();
        OlapBuilderInputType cubeDataType = OlapInstr.extractCubeDataType(refMeasures);
        OlapUserMeasureMember measure = new OlapUserMeasureMember(level, measureGroup, measureName, hierarchyAggregationType, rollupHierarchy, emptyIsZero, cubeDataType, properties, definedAtSelectStatementLevel, refMeasures);
        return measure;
    }

    private List<OlapMeasureMember> evalRefMeasures(OlapCreateMeasureEvaluationContext context, String measureName, OlapInstr formula) {
        OlapMeasureMember measure;
        OlapEntity res;
        if (formula instanceof OlapIdentifierInstr && (res = formula.execute(context)) instanceof OlapMeasureMember && (measure = (OlapMeasureMember)res).isRegular()) {
            return Collections.singletonList((OlapMeasureMember)res);
        }
        throw new OlapEvaluationException(context, OlapErrorCode.MEASURE_FORMULA_NOT_SUPPORTED, new Serializable[]{measureName});
    }

    private IOlapBuilderBaseFactsDef assertSingleMeasureGroup(OlapCreateMeasureEvaluationContext context, String measureName, List<OlapMeasureMember> measures) {
        IOlapBuilderBaseFactsDef measureGroup = null;
        for (OlapMeasureMember measure : measures) {
            if (measureGroup == null) {
                measureGroup = measure.getMeasureGroup();
                continue;
            }
            if (measureGroup == measure.getMeasureGroup()) continue;
            return (IOlapBuilderBaseFactsDef)OlapInstr.onInstrExecutionError(context, OlapErrorCode.MEASURE_MULTIPLE_MEASURE_GROUPS, new Serializable[]{measureName, OlapInstr.extractMeasureGroups(measures)});
        }
        if (measureGroup == null) {
            return (IOlapBuilderBaseFactsDef)OlapInstr.onInstrExecutionError(context, OlapErrorCode.MEASURE_MISSING_MEASURES, new Serializable[]{measureName});
        }
        return measureGroup;
    }

    private static String extractMeasureGroups(List<OlapMeasureMember> measures) {
        StringBuilder sb = new StringBuilder();
        for (int mm = 0; mm < measures.size(); ++mm) {
            OlapMeasureMember measure = measures.get(mm);
            if (mm > 0) {
                sb.append(",");
            }
            sb.append("[").append(measure.getNameX()).append("]@[").append(measure.getMeasureGroupName()).append("]");
        }
        return sb.toString();
    }

    public static void inheritFormatString(OlapCellProperties properties, List<OlapMeasureMember> refMeasures) {
        OlapCellPropertyValue formatString;
        if (properties.isFormatStringDefined()) {
            return;
        }
        if (refMeasures.size() != 1) {
            return;
        }
        OlapCellProperties refMeasureProperties = refMeasures.get(0).getCellProperties();
        if (refMeasureProperties != null && (formatString = refMeasureProperties.getFormatString()) != null) {
            properties.setFormatString(formatString);
        }
    }

    public static void inheritEmptyIsZero(OlapCellProperties properties, List<OlapMeasureMember> refMeasures) {
        if (properties.isEmptyIsZeroDefined()) {
            return;
        }
        if (refMeasures.size() != 1) {
            return;
        }
        if (refMeasures.get(0).isEmptyIsZero()) {
            properties.setEmptyIsZero(true);
        }
    }

    private static OlapBuilderInputType extractCubeDataType(List<OlapMeasureMember> refMeasures) {
        OlapBuilderInputType dataType = null;
        for (OlapMeasureMember refMeasure : refMeasures) {
            OlapBuilderInputType type = refMeasure.getCubeDataType();
            if (dataType == null) {
                dataType = type;
                continue;
            }
            if (dataType == type) continue;
            dataType = OlapBuilderInputType.DB_TYPE_UNKNOWN;
            break;
        }
        if (dataType == null) {
            dataType = OlapBuilderInputType.DB_TYPE_UNKNOWN;
        }
        return dataType;
    }

    public boolean isNativeJava() {
        return false;
    }

    @Nullable
    public MdxFunctionNativeBodyExpression getNativeFunctionSourceCode() {
        return null;
    }
}

