/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.tuple;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapFilteredOutTuple;
import crazydev.iccube.olap.entity.tuple.OlapInvalidTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class OlapRootFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Root";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, 1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapRootFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        if (args.isMissingArg(0)) {
            return OlapRootFunction.evalForAllDimensions(context, args);
        }
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "tuple|hierarchy|dimension");
        if (arg0.isMdxNull()) {
            return OlapInvalidTuple.INSTANCE;
        }
        if (arg0 instanceof OlapDimension) {
            return OlapRootFunction.evalForDimension(context, args, (OlapDimension)arg0);
        }
        if (arg0 instanceof OlapHierarchy) {
            return OlapRootFunction.evalForDimension(context, args, ((OlapHierarchy)arg0).getDimension());
        }
        if (arg0 instanceof OlapTuple) {
            OlapTuple tuple = (OlapTuple)arg0;
            if (tuple.isKO()) {
                return tuple;
            }
            return OlapRootFunction.evalForTuple(context, args, tuple);
        }
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "tuple|hierarchy|dimension", arg0.getFriendlyTypeName());
    }

    private static OlapNonScalarEntity evalForAllDimensions(GFContext context, GFFunctionArgs args) {
        List<OlapDimension> dimensions = args.getAllDimensions(context);
        List<OlapHierarchy> hierarchies = OlapRootFunction.getAllHierarchies(context, args, dimensions);
        return OlapRootFunction.evalForHierarchies(context, args, hierarchies);
    }

    private static OlapNonScalarEntity evalForDimension(GFContext context, GFFunctionArgs args, OlapDimension dimension) {
        return OlapRootFunction.evalForHierarchies(context, args, dimension.getHierarchies(args.getDimensionsPermissions(context)));
    }

    private static OlapNonScalarEntity evalForHierarchies(GFContext context, GFFunctionArgs args, List<OlapHierarchy> hierarchies) {
        int hierarchiesSize = hierarchies.size();
        OlapMember[] members = new OlapMember[hierarchiesSize];
        for (int idx = 0; idx < hierarchiesSize; ++idx) {
            OlapHierarchy hierarchy = hierarchies.get(idx);
            OlapMember member = hierarchy.getAllMember();
            if (member == null && (member = hierarchy.getNullableDefaultMember(args.getMemberFilter(context))) == null) {
                return OlapFilteredOutTuple.INSTANCE;
            }
            members[idx] = member;
        }
        return OlapRootFunction.asTuple(context, args, members);
    }

    private static OlapNonScalarEntity evalForTuple(GFContext context, GFFunctionArgs args, OlapTuple tuple) {
        HashMap<OlapHierarchy, OlapMember> tupleMembersByHierarchy = new HashMap<OlapHierarchy, OlapMember>();
        for (int idx = 0; idx < tuple.getMemberCount(); ++idx) {
            OlapMember member = tuple.getMember(idx);
            tupleMembersByHierarchy.put(member.getHierarchy(), member);
        }
        List<OlapDimension> dimensions = tuple.getDimensions();
        List<OlapHierarchy> hierarchies = OlapRootFunction.getAllHierarchies(context, args, dimensions);
        OlapMember[] members = new OlapMember[hierarchies.size()];
        int hierarchiesSize = hierarchies.size();
        for (int idx = 0; idx < hierarchiesSize; ++idx) {
            OlapHierarchy hierarchy = hierarchies.get(idx);
            OlapMember member = (OlapMember)tupleMembersByHierarchy.get(hierarchy);
            if (member == null && (member = hierarchy.getAllMember()) == null && (member = hierarchy.getNullableDefaultMember(args.getMemberFilter(context))) == null) {
                return OlapFilteredOutTuple.INSTANCE;
            }
            members[idx] = member;
        }
        return OlapRootFunction.asTuple(context, args, members);
    }

    private static OlapNonScalarEntity asTuple(GFContext context, GFFunctionArgs args, OlapMember[] members) {
        OlapTupleDimensionalityCache cache = args.getTupleDimensionalityCache(context);
        OlapTuple roots = OlapTupleFactory.instance(args.getErrorContext(context), cache, (OlapTupleDimensionality)null, members);
        return roots;
    }

    private static List<OlapHierarchy> getAllHierarchies(GFContext context, GFFunctionArgs args, Collection<OlapDimension> dimensions) {
        ArrayList<OlapHierarchy> allHierarchies = new ArrayList<OlapHierarchy>();
        for (OlapDimension dimension : dimensions) {
            List<OlapHierarchy> hierarchies = dimension.getHierarchies(args.getDimensionsPermissions(context));
            allHierarchies.addAll(hierarchies);
        }
        return allHierarchies;
    }
}

