/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.subcube;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class OlapMdxSubCubeFunction
extends OlapNonScalarEntityFunction {
    public OlapMdxSubCubeFunction(String name, OlapFunctionArgs arguments) {
        super(name, arguments);
    }

    @Override
    public boolean withPostFixedNotation() {
        return false;
    }

    @Override
    public boolean isSubCubeXyz() {
        return true;
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        ArrayList<OlapNonScalarEntity> resolvedArgs = new ArrayList<OlapNonScalarEntity>();
        int size = args.size();
        if (size == 0) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT, new Serializable[]{"0", "1..N"});
        }
        for (int ii = 0; ii < size; ++ii) {
            if (args.isMissingArg(ii)) {
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.FUNCTION_ARGUMENT_NULL, new Serializable[]{"0", "set|sub-cube"});
            }
            OlapEntity arg = args.getNonMissingArgEntity(context, ii, "set|sub-cube");
            if (arg instanceof OlapSubCubeEntity) {
                resolvedArgs.add((OlapSubCubeEntity)arg);
                continue;
            }
            OlapTupleSet<? extends OlapTuple> asSet = args.toSetIfApplicable(context, ii);
            if (asSet == null) {
                return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, ii, "set|sub-cube", arg.getFriendlyTypeName());
            }
            OlapTupleSet<? extends OlapTuple> materializedSet = asSet.materialize();
            this.assertSetConsistency(context, args, materializedSet);
            resolvedArgs.add(materializedSet);
        }
        return this.createOlapSubCube(resolvedArgs);
    }

    private void assertSetConsistency(GFContext context, GFFunctionArgs args, OlapTupleSet<? extends OlapTuple> set) {
        OlapTuple tuple;
        OlapIterator tuples = set.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            int count = tuple.getMemberCount();
            for (int ii = 0; ii < count; ++ii) {
                OlapMember member = tuple.getMember(ii);
                if (member.isCalculated()) {
                    args.onFunctionError(context, OlapErrorCode.SUB_CUBE_UNEXPECTED_CALCULATED_MEMBER, new Serializable[]{ONames.uname4Log(member)});
                    continue;
                }
                if (!member.isMeasure()) continue;
                args.onFunctionError(context, OlapErrorCode.SUB_CUBE_UNEXPECTED_MEASURE_MEMBER, new Serializable[]{ONames.uname4Log(member)});
            }
        }
    }

    protected abstract OlapNonScalarEntity createOlapSubCube(List<OlapNonScalarEntity> var1);
}

