/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.string;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;

public class OlapPropertiesFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "Properties";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapPropertiesFunction() {
        super(NAME, ARGS);
    }

    protected OlapPropertiesFunction(String name, OlapFunctionArgs args) {
        super(name, args);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        boolean typed;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member");
        if (arg0.isMdxNull()) {
            return OlapPropertiesFunction.asEmpty();
        }
        OlapMember member = args.toMember(context, 0);
        String propName = args.toString(context, 1);
        if (!args.isMissingArg(2)) {
            args.toOption(context, 2, OlapOption.TYPED);
            typed = true;
        } else {
            typed = false;
        }
        return this.evalProperty(context, member, propName, typed);
    }

    protected boolean isNullable() {
        return false;
    }

    private OlapScalarEntity evalProperty(GFContext context, OlapMember member, String propName, boolean typed) {
        OlapScalarEntity propertyValue = context.evalPropertyValue(member, propName, typed);
        boolean isNullable = this.isNullable();
        if (propertyValue == null && !isNullable) {
            OlapLevel level = member.getLevel();
            return (OlapScalarEntity)this.onFunctionError(context, OlapErrorCode.PROPERTY_NOT_FOUND, new Serializable[]{propName, level.getUniqueName(context.getNameContext())});
        }
        return isNullable ? OlapPropertiesFunction.asNullable(propertyValue) : propertyValue;
    }
}

