/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsCluster;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.CONDITIONALLY_THREAD_SAFE)
public class OlapVisualTotalsManager {
    private final Map<OlapHierarchy, OlapVisualTotalsCluster> visualTotalsClusters = new HashMap<OlapHierarchy, OlapVisualTotalsCluster>();
    private volatile boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OlapVisualTotalsCluster cluster) {
        if (cluster.getHierarchy() != null && !cluster.isEmpty()) {
            Map<OlapHierarchy, OlapVisualTotalsCluster> map = this.visualTotalsClusters;
            synchronized (map) {
                this.visualTotalsClusters.put(cluster.getHierarchy(), cluster);
                this.isActive = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<OlapMember> getVisualMembers(OlapMember member) {
        OlapVisualTotalsCluster.Node node;
        OlapVisualTotalsCluster cluster;
        Map<OlapHierarchy, OlapVisualTotalsCluster> map = this.visualTotalsClusters;
        synchronized (map) {
            cluster = this.visualTotalsClusters.get(member.getHierarchy());
        }
        if (cluster != null && (node = cluster.getClusterNode(member)) != null) {
            return node.getAllVisualMembers();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCaption(OlapMember member, String currentCaption) {
        OlapVisualTotalsCluster cluster;
        Map<OlapHierarchy, OlapVisualTotalsCluster> map = this.visualTotalsClusters;
        synchronized (map) {
            cluster = this.visualTotalsClusters.get(member.getHierarchy());
        }
        if (cluster != null) {
            String newCaption = cluster.getCaption(member, currentCaption);
            return newCaption;
        }
        return currentCaption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCaption(OlapMember member) {
        OlapVisualTotalsCluster cluster;
        Map<OlapHierarchy, OlapVisualTotalsCluster> map = this.visualTotalsClusters;
        synchronized (map) {
            cluster = this.visualTotalsClusters.get(member.getHierarchy());
        }
        if (cluster != null) {
            return cluster.hasCaption(member);
        }
        return false;
    }
}

