/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.io.Serializable;
import java.util.ArrayList;

public class OlapUnionFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Union";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapUnionFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int setCount = 0;
        OlapOption flag = null;
        ArrayList<OlapTupleSet<? extends OlapTuple>> sets = new ArrayList<OlapTupleSet<? extends OlapTuple>>();
        for (int idx = 0; idx < args.size(); ++idx) {
            if (args.isMissingArg(idx)) continue;
            OlapEntity arg = args.getNonMissingArgEntity(context, idx, "set|ALL");
            if (arg.isMdxNull()) {
                ++setCount;
                continue;
            }
            if (arg instanceof OlapOption) {
                if (flag != null) {
                    return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, idx, "set", arg.getFriendlyTypeName());
                }
                flag = (OlapOption)arg;
                if (OlapOption.ALL == flag) continue;
                return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, idx, "ALL", flag.getFriendlyTypeName());
            }
            if (flag != null) {
                return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, idx, "set", arg.getFriendlyTypeName());
            }
            OlapTupleSet<? extends OlapTuple> set = args.toSet(context, idx);
            sets.add(set);
            ++setCount;
        }
        if (setCount <= 1) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.UNEXPECTED_SET_COUNT, new Serializable[0]);
        }
        boolean retainDuplicates = OlapOption.ALL == flag;
        OlapIterator<? extends OlapTuple> union = OlapIteratorFactory.union(args.getErrorContext(context), sets, retainDuplicates);
        return OlapSetFactory.instance(union);
    }
}

