/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;

public class OlapPeriodsToDateFunction
extends OlapMdxTimeNavigationFunction {
    public static final String NAME = "PeriodsToDate";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, 2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapPeriodsToDateFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member;
        OlapLevel level;
        if (args.isMissingArg(0)) {
            level = this.getParentLevelOfTimeCurrentMemberForCluster(context, args, 0);
        } else {
            OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "level");
            if (arg0.isMdxNull()) {
                return OlapSetFactory.empty();
            }
            level = args.toLevel(context, 0);
        }
        if (args.isMissingArg(1)) {
            OlapHierarchy timeHierarchy = level.getHierarchy();
            member = args.getNullableCurrentMember(context, timeHierarchy);
            if (member == null) {
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_CURRENT_MEMBER, new Serializable[]{timeHierarchy.getUniqueName(args.getNameContext(context)), args.getUnderlyingCubeName(context)});
            }
        } else {
            OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "member");
            if (arg1.isMdxNull()) {
                return OlapSetFactory.empty();
            }
            member = args.toMember(context, 1);
        }
        this.assertSameHierarchy(args.getErrorContext(context), level, member);
        return member.periodsToDate(args.getMemberFilter(context), level);
    }
}

