/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.IOlapSortedVTuples;
import crazydev.iccube.collection.OlapSortedVTuplesMT;
import crazydev.iccube.collection.OlapUnboundedSortedVTuples;
import crazydev.iccube.collection.OlapVTuple;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleHierarchizer;
import crazydev.iccube.olap.eval.execinstr.OlapOrderApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFOrderApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapOrderFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Order";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 4){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1;
        }

        @Override
        public boolean isOption(int pos) {
            return pos == 2 || pos == 3;
        }
    };

    public OlapOrderFunction() {
        super(NAME, ARGS);
    }

    private Comparator<OlapVTuple<OlapScalarEntity>> createSortedTuplesComparator(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, OlapOption option) {
        Comparator<String> stringComparator = context.getSchema().getLocalizedStringComparator();
        if (OlapOption.BASC == option) {
            return OlapVTuple.ASC_COMPARATOR(stringComparator);
        }
        if (OlapOption.BDESC == option) {
            return OlapVTuple.DESC_COMPARATOR(stringComparator);
        }
        if (OlapOption.ASC == option) {
            return new AscDescComparator(context, lambdaTupleEvaluator, miniTupleEvaluator, OlapVTuple.RAW_ASC_COMPARATOR(stringComparator));
        }
        if (OlapOption.DESC == option) {
            return new AscDescComparator(context, lambdaTupleEvaluator, miniTupleEvaluator, OlapVTuple.RAW_DESC_COMPARATOR(stringComparator));
        }
        throw new CdProgrammingException("unexpected option : " + String.valueOf(option));
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        return new OlapOrderApplyLambdaPreparedInstr(callInstr, args, (OlapFunction)this, pArgs, (x$0, x$1, x$2, x$3, x$4) -> new Callback(this, x$0, x$1, x$2, x$3, x$4));
    }

    private static class AscDescComparator
    implements Comparator<OlapVTuple<OlapScalarEntity>> {
        private final GFContext context;
        private final GFLambdaTupleEvaluator lambdaTupleEvaluator;
        private final GFMiniTupleEvaluator miniTupleEvaluator;
        private final Comparator<OlapVTuple<OlapScalarEntity>> siblingsComparator;
        private final Map<OlapTuple, OlapScalarEntity> cache = new HashMap<OlapTuple, OlapScalarEntity>();
        private int cacheHit = 0;
        private int cacheMissed = 0;

        AscDescComparator(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, Comparator<OlapVTuple<OlapScalarEntity>> siblingsComparator) {
            this.context = context;
            this.lambdaTupleEvaluator = lambdaTupleEvaluator;
            this.miniTupleEvaluator = miniTupleEvaluator;
            this.siblingsComparator = siblingsComparator;
        }

        @Override
        public int compare(OlapVTuple t1, OlapVTuple t2) {
            OlapVTuple<OlapScalarEntity> root2;
            OlapVTuple<OlapScalarEntity> root1;
            int comp;
            OlapLevel sortingLevel;
            int comp2;
            int size = t1.getMemberCount();
            for (int idx = 0; idx < size - 1; ++idx) {
                OlapMember m2;
                OlapMember m1 = t1.getMember(idx);
                int comp3 = OlapTupleHierarchizer.compareMembers(this.context, m1, m2 = t2.getMember(idx));
                if (comp3 == 0) continue;
                return comp3;
            }
            OlapMember m1 = t1.getMember(size - 1);
            OlapMember m2 = t2.getMember(size - 1);
            if (OlapMember.equal(m1.getParent(), m2.getParent()) && (comp2 = this.siblingsComparator.compare(t1, t2)) != 0) {
                return comp2;
            }
            OlapMember rootBranching = m1.getBranchingMember(m2);
            if (OlapMember.equal(rootBranching, m1) || OlapMember.equal(rootBranching, m2)) {
                return OlapTupleHierarchizer.compareMembers(this.context, m1, m2);
            }
            if (rootBranching != null) {
                IOlapHierarchyPermission permissions;
                OlapLevel nextLevel = rootBranching.getLevel().getNextLevel();
                if (nextLevel != null && !(permissions = this.context.getHierarchyPermissionsWithoutPerspective(rootBranching.getHierarchy())).isLevelAuthorized(nextLevel)) {
                    nextLevel = null;
                }
                sortingLevel = nextLevel;
            } else {
                sortingLevel = m1.getHierarchy().getFirstLevel();
            }
            if (sortingLevel != null && (comp = this.siblingsComparator.compare(root1 = this.replaceLastMember(t1, m1, sortingLevel), root2 = this.replaceLastMember(t2, m2, sortingLevel))) != 0) {
                return comp;
            }
            return this.naturalCompare(t1, t2);
        }

        private int naturalCompare(OlapVTuple t1, OlapVTuple t2) {
            return OlapTupleHierarchizer.compareTuples(t1.tuple, t2.tuple);
        }

        public OlapVTuple<OlapScalarEntity> replaceLastMember(OlapVTuple<OlapScalarEntity> vTuple, OlapMember member, OlapLevel lookupLevel) {
            OlapTuple newTuple;
            int tupleSize = vTuple.tuple.getMemberCount();
            if (tupleSize == 1) {
                if (lookupLevel == member.getLevel()) {
                    return vTuple;
                }
                newTuple = member.getAncestor(lookupLevel);
            } else {
                newTuple = vTuple.tuple.replace(tupleSize - 1, member.getAncestor(lookupLevel));
            }
            OlapScalarEntity newValue = this.getValue(newTuple);
            return new OlapVTuple<OlapScalarEntity>(newTuple, newValue, vTuple.getPos());
        }

        private OlapScalarEntity getValue(OlapTuple newTuple) {
            OlapScalarEntity value = this.cache.get(newTuple);
            if (value == null) {
                value = this.lambdaTupleEvaluator.evaluateAsScalar(this.context, this.miniTupleEvaluator, OlapSetFactory.empty(), newTuple, -1);
                this.cache.put(newTuple, value);
                ++this.cacheMissed;
            } else {
                ++this.cacheHit;
            }
            return value;
        }
    }

    class Callback
    extends GFApplyLambdaCallback<GFOrderApplyLambdaNode> {
        private final Object LOCK;
        @Nullable
        private volatile OlapLambdaCallbackMode processingMode;
        private volatile boolean parallelMode;
        private volatile IOlapSortedVTuples stuples;
        private volatile OlapOption option;
        private volatile boolean excludeEmpty;
        final /* synthetic */ OlapOrderFunction this$0;

        Callback(OlapOrderFunction this$0, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            OlapOrderFunction olapOrderFunction = this$0;
            Objects.requireNonNull(olapOrderFunction);
            this.this$0 = olapOrderFunction;
            super(functionCallInstr, functionCallArgInstrs, function, "numeric_expression");
            this.LOCK = new Object();
            this.parallelMode = false;
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            if (this.processingMode != null) {
                return this.processingMode;
            }
            return OlapLambdaCallbackMode.SEQUENTIAL;
        }

        @Override
        public void init(GFContext context, OlapTupleSet set, GFOrderApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            context.invalidateCurrentIteratedTupleUsage();
            OlapOption option = lambdaArg.getEvaluatedOption(context, args, OlapOption.BASC, OlapOption.BDESC, OlapOption.ASC, OlapOption.DESC);
            if (option == null) {
                option = OlapOption.ASC;
            }
            this.excludeEmpty = lambdaArg.excludeEmpty(context, args);
            this.option = option;
            this.processingMode = this.option == OlapOption.BDESC || this.option == OlapOption.BASC ? OlapLambdaCallbackMode.PARALLEL : OlapLambdaCallbackMode.SEQUENTIAL;
        }

        @Override
        public void initX(GFContext context, boolean parallel, OlapTupleSet set, GFOrderApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.parallelMode = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBeforeSetBatchEvaluation(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator) {
            if (this.stuples == null) {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this.stuples == null) {
                        Comparator<OlapVTuple<OlapScalarEntity>> tupleComparator = this.this$0.createSortedTuplesComparator(context, lambdaTupleEvaluator, miniTupleEvaluator, this.option);
                        this.stuples = new OlapUnboundedSortedVTuples(context.getErrorLocation(), this.this$0.getName(), context.getInternalTupleListCount(), tupleComparator, this.excludeEmpty);
                        if (this.parallelMode) {
                            this.stuples = new OlapSortedVTuplesMT(this.stuples);
                        }
                    }
                }
            }
        }

        @Override
        public void onEmptyValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple) {
            this.stuples.addEmpty(iTuple, iTupleOrdinal);
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            this.stuples.add(iTuple, value, iTupleOrdinal);
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            if (this.stuples == null) {
                return OlapSetFactory.empty();
            }
            return this.stuples.asSet();
        }

        @Override
        public void onFinally(GFContext context) {
            context.validateCurrentIteratedTupleUsage();
        }
    }
}

