/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.io.Serializable;

public class OlapNonEmptyMembersFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "NonEmptyMembers";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3);

    public OlapNonEmptyMembersFunction() {
        this(NAME);
    }

    public OlapNonEmptyMembersFunction(String name) {
        super(name, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet<OlapMember> set = args.toMemberSet(context, 0, false);
        if (set == null) {
            throw new RuntimeException("internal error : unexpected null set");
        }
        OlapIterator<OlapMember> setIterator = set.getIterator(false);
        OlapTuple tuple = args.toTuple(context, 1);
        OlapMember measure = tuple.getMeasureMember();
        if (this.checkDimensionalityError(setIterator, tuple)) {
            return (OlapNonScalarEntity)this.onFunctionError(context, OlapErrorCode.NO_EMPTY_MEMBERS_DIMENSIONALITY_MISMATCH, new Serializable[0]);
        }
        if (measure instanceof OlapMeasureMember && !tuple.isCalculated()) {
            IOlapIteratorFilter<OlapMember> filter = context.getFastNonEmptyFilter(tuple, (OlapMeasureMember)measure);
            OlapIterator<OlapMember> filtered = OlapIteratorFactory.filter(setIterator, filter);
            Integer limit = args.toOptionalInteger(context, 2);
            OlapIterator<OlapMember> limitedFiltered = limit != null ? OlapIteratorFactory.head(filtered, limit) : filtered;
            return OlapSetFactory.instance(limitedFiltered);
        }
        return (OlapNonScalarEntity)this.onFunctionError(context, OlapErrorCode.REGULAR_MEASURE_MISMATCH, new Serializable[0]);
    }

    private boolean checkDimensionalityError(OlapIterator<OlapMember> setIterator, OlapTuple tuple) {
        OlapTupleDimensionality setDimensionality = setIterator.getTupleDimensionality();
        if (setDimensionality != null && setDimensionality.intersects(tuple.getTupleDimensionality())) {
            return true;
        }
        OlapMember first = setIterator._getSlow(0);
        return first != null && first.getTupleDimensionality().intersects(tuple.getTupleDimensionality());
    }
}

