/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapAllMembersFunction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapMembersFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Members";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapMembersFunction() {
        super(NAME, ARGS);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality(GFNode[] args) {
        return this.getTupleDimensionality(args, 0);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "level|hierarchy|dimension");
        if (arg0.isMdxNull()) {
            return OlapMembersFunction.asNull();
        }
        if (arg0 instanceof OlapLevel) {
            OlapMemberFilter memberFilter = args.getMemberFilter(context);
            return this.doEvalForLevel(context, args, memberFilter, (OlapLevel)arg0);
        }
        if (arg0 instanceof OlapHierarchy) {
            OlapMemberFilter memberFilter = args.getMemberFilter(context);
            return this.doEvalForHierarchy(context, args, memberFilter, (OlapHierarchy)arg0);
        }
        if (arg0 instanceof OlapDimension) {
            OlapHierarchy hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension)arg0);
            OlapMemberFilter memberFilter = args.getMemberFilter(context);
            return this.doEvalForHierarchy(context, args, memberFilter, hierarchy);
        }
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "level|hierarchy|dimension", arg0.getFriendlyTypeName());
    }

    private OlapNonScalarEntity doEvalForLevel(GFContext context, GFFunctionArgs args, @Nullable OlapMemberFilter memberFilter, OlapLevel level) {
        if (level.isMembersAllMembers()) {
            return OlapAllMembersFunction.doEvalForLevelForCluster(context, args, level);
        }
        OlapTupleSet<OlapMember> levelMembers = level.getMembers(memberFilter);
        if (!level.getHierarchy().isMeasures()) {
            return levelMembers;
        }
        return this.withUserDefinedMeasures(context, memberFilter, levelMembers);
    }

    private OlapNonScalarEntity doEvalForHierarchy(GFContext context, GFFunctionArgs args, @Nullable OlapMemberFilter memberFilter, OlapHierarchy hierarchy) {
        if (hierarchy.isMembersAllMembers()) {
            return OlapAllMembersFunction.doEvalForHierarchyForCluster(context, args, hierarchy);
        }
        OlapTupleSet<OlapMember> hierarchyMembers = hierarchy.getMembers(memberFilter);
        if (!hierarchy.isMeasures()) {
            return hierarchyMembers;
        }
        return this.withUserDefinedMeasures(context, memberFilter, hierarchyMembers);
    }

    private OlapNonScalarEntity withUserDefinedMeasures(GFContext context, @Nullable OlapMemberFilter memberFilter, OlapTupleSet<OlapMember> regularMeasures) {
        OlapMember regularMeasure;
        List<OlapUserMeasureMember> userDefinedMeasures = context.lookupUserDefinedMeasures(memberFilter);
        if (userDefinedMeasures.isEmpty()) {
            return regularMeasures;
        }
        ArrayList<OlapMember> allMeasures = new ArrayList<OlapMember>();
        OlapIterator regularMeasures_ = regularMeasures.getIterator(false);
        regularMeasures_.reset();
        while ((regularMeasure = (OlapMember)regularMeasures_.next()) != null) {
            allMeasures.add(regularMeasure);
        }
        allMeasures.addAll(userDefinedMeasures);
        return OlapSetFactory.instance(allMeasures);
    }
}

