/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapGenerateApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenerateApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapEntityFunction;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapGenerateFunction
extends OlapEntityFunction {
    public static final String NAME = "Generate";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapGenerateFunction() {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        return new OlapGenerateApplyLambdaPreparedInstr(callInstr, args, (OlapFunction)this, pArgs, Callback::new);
    }

    static class Callback
    extends GFApplyLambdaCallback<GFGenerateApplyLambdaNode> {
        private List<OlapTupleSet<? extends OlapTuple>> generated;
        private StringBuilder sb;
        private boolean isEmptySet;
        @Nullable
        private String delimiter;
        private boolean keepDuplicate;
        private boolean forSet;
        private boolean forString;

        Callback(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            super(functionCallInstr, functionCallArgInstrs, function, "set_expression|string_expression");
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.SEQUENTIAL;
        }

        @Override
        public void init(GFContext context, OlapTupleSet set, GFGenerateApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.generated = new ArrayList<OlapTupleSet<? extends OlapTuple>>();
            this.sb = null;
            this.isEmptySet = true;
            this.delimiter = lambdaArg.getDelimiter();
            this.keepDuplicate = false;
            this.forSet = false;
            this.forString = false;
            if (this.delimiter != null) {
                this.forSet = false;
                this.forString = true;
            } else {
                Boolean keepDuplicate_ = lambdaArg.getKeepDuplicate();
                if (keepDuplicate_ != null) {
                    this.keepDuplicate = keepDuplicate_;
                    this.forSet = true;
                    this.forString = false;
                } else {
                    this.keepDuplicate = false;
                    this.forSet = false;
                    this.forString = false;
                }
            }
        }

        @Override
        public void onEmptyValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple) {
            this.isEmptySet = false;
            if (!this.forSet) {
                this.append("");
            }
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            this.isEmptySet = false;
            if (this.forSet) {
                this.onFunctionArgTypeMismatchError(context, "set", value.getFriendlyTypeName());
            }
            this.forString = true;
            this.append(value.asString());
        }

        private void append(String value) {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            } else if (this.delimiter != null) {
                this.sb.append(this.delimiter);
            }
            this.sb.append(value);
        }

        @Override
        public void onNonScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapEntity value) {
            this.isEmptySet = false;
            if (this.forString) {
                this.onFunctionArgTypeMismatchError(context, "string", value.getFriendlyTypeName());
                return;
            }
            this.forSet = true;
            if (value instanceof OlapTupleSet) {
                OlapTupleSet set = (OlapTupleSet)value;
                this.generated.add(set);
            } else {
                this.onFunctionArgTypeMismatchError(context, "set", value.getFriendlyTypeName());
            }
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            if (this.isEmptySet) {
                return OlapGenerateFunction.asNull();
            }
            if (this.forString) {
                return new OlapStringEntity(this.sb != null ? this.sb.toString() : "");
            }
            if (this.forSet) {
                OlapIterator<? extends OlapTuple> union = OlapIteratorFactory.union(context, this.generated, this.keepDuplicate);
                OlapTupleSet<? extends OlapTuple> res = OlapSetFactory.instance(union);
                return res;
            }
            return OlapGenerateFunction.asNull();
        }
    }
}

