/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapITuple;
import crazydev.iccube.collection.OlapITupleList;
import crazydev.iccube.collection.OlapITupleListMT;
import crazydev.iccube.collection.OlapITupleListST;
import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapGenericApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapIteratorApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapGFIteratorFunctionUtils;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.concurrent.atomic.AtomicReference;

public class OlapFilterFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Filter";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            if (pos == 2) {
                return OlapFunctionArgumentType.VALUE;
            }
            return super.getType(pos);
        }
    };

    public OlapFilterFunction() {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        if (OlapGFIteratorFunctionUtils.isLambdaWithoutLimit(context)) {
            return new OlapGenericApplyLambdaPreparedInstr(callInstr, args, this, pArgs, Callback::new, -1);
        }
        int limitFromContext = OlapFilterFunction.prepareLimit(context, callInstr);
        OlapProperties props = context.getRequestProperties();
        OlapFilterProcessingMode mode = props.getMdxEvalFilterProcessingMode();
        if (mode == OlapFilterProcessingMode.LAMBDA) {
            return new OlapGenericApplyLambdaPreparedInstr(callInstr, args, this, pArgs, Callback::new, limitFromContext);
        }
        if (mode == OlapFilterProcessingMode.ITERATOR || mode == OlapFilterProcessingMode.ITERATOR_ST) {
            return new OlapIteratorApplyLambdaPreparedInstr(mode, Callback::new, false, callInstr, args, this, pArgs, limitFromContext);
        }
        throw new RuntimeException("internal error : unexpected Filter() processing mode [" + String.valueOf((Object)mode) + "]");
    }

    static class Callback
    extends GFApplyLambdaCallback<GFGenericApplyLambdaNode> {
        private final AtomicReference<OlapITupleList> filtered;
        private boolean needsSorting;

        Callback(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            super(functionCallInstr, functionCallArgInstrs, function, "logical_expression");
            this.filtered = new AtomicReference<OlapITupleListST>(new OlapITupleListST(functionCallInstr.getLocationRange(), functionCallInstr.getFunctionName(), internalTupleListCount, limit));
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.PARALLEL;
        }

        @Override
        public void initX(GFContext context, boolean parallel, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.needsSorting = parallel;
            int limit = OlapNonScalarEntityFunction.actualLimitForInitX(context, args, this.filtered.get());
            if (args.size() == 3) {
                if (parallel) {
                    this.filtered.set(new OlapITupleListMT(lambdaArg.getLocationRange(), lambdaArg.getFunctionName(), context.getInternalTupleListCount(), limit));
                } else {
                    this.filtered.set(new OlapITupleListST(lambdaArg.getLocationRange(), lambdaArg.getFunctionName(), context.getInternalTupleListCount(), limit));
                }
            } else if (parallel) {
                this.filtered.set(new OlapITupleListMT(lambdaArg.getLocationRange(), lambdaArg.getFunctionName(), context.getInternalTupleListCount(), limit));
            }
        }

        @Override
        public int stopIterationOrdinal() {
            return this.filtered.get().stopIterationOrdinal();
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            OlapAbstractScalarEntity scalar;
            Object nativeValue;
            if (value instanceof OlapAbstractScalarEntity && (nativeValue = (scalar = (OlapAbstractScalarEntity)value).doAsJavaNativeValue(Boolean.TYPE)) instanceof Boolean) {
                boolean flag = (Boolean)nativeValue;
                if (flag) {
                    this.filtered.get().add(new OlapITuple(iTuple, iTupleOrdinal));
                }
                return;
            }
            this.onFunctionArgTypeMismatchError(context, "scalar", value.getFriendlyTypeName());
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            return this.filtered.get().sort(this.needsSorting);
        }
    }
}

