/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.OlapFastCrossjoinIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapExpandFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "Expand";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapExpandFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet set;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member");
        if (arg0.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        OlapMember member = args.toMemberIfApplicable(context, 0);
        if (member != null) {
            set = OlapSetFactory.instance((OlapTuple[])new OlapMember[]{member});
        } else {
            OlapTupleSet expanded;
            set = args.toSet(context, 0);
            if (set.isMembersCrossjoin() && (expanded = set.decorateMemberCrossjoin(memberSet -> new ExpandIterator((OlapIterator<OlapMember>)memberSet, args.getMemberFilter(context)))) != null) {
                return expanded;
            }
        }
        OlapMemberFilter filter = args.getMemberFilter(context);
        if (set.getTupleDimensionality() != null && set.getTupleDimensionality().cardinality() != 1) {
            OlapTupleFilter tupleFilter = args.getTupleFilter(context);
            OlapFastCrossjoinContext cjContext = new OlapFastCrossjoinContext(context.getStatementExecutionContext(), context.getPrepareContext(), S_NonEmptyBehavior.one());
            return this.onTupleSet(set, filter, tupleFilter, cjContext);
        }
        return OlapExpandFunction.onMemberSet(set, filter);
    }

    @NotNull
    private static OlapTupleSet<OlapMember> onMemberSet(OlapTupleSet<? extends OlapTuple> set, OlapMemberFilter filter) {
        return OlapSetFactory.instance(new ExpandIterator(set.getIterator(false), filter));
    }

    private OlapNonScalarEntity onTupleSet(OlapTupleSet<? extends OlapTuple> set, OlapMemberFilter filter, OlapTupleFilter tupleFilter, OlapFastCrossjoinContext context) {
        return OlapSetFactory.instance(new ExpandTupleIterator(set.getIterator(false), filter, tupleFilter, context));
    }

    private static class ExpandIterator
    extends OlapBaseIterator<OlapMember> {
        private final OlapIterator<OlapMember> memberSet;
        private final OlapMemberFilter memberFilter;
        private OlapIterator<OlapMember> currentBase;

        public ExpandIterator(OlapIterator<OlapMember> memberSet, @Nullable OlapMemberFilter memberFilter) {
            this.memberSet = memberSet;
            this.memberFilter = memberFilter;
        }

        @Override
        @Nullable
        protected OlapMember safeNext() {
            OlapMember next;
            if (this.currentBase == null) {
                OlapMember nextBaseMember = this.memberSet.next();
                if (nextBaseMember == null) {
                    return null;
                }
                this.currentBase = nextBaseMember.getChildrenR(this.memberFilter, null, true);
                this.currentBase.reset();
            }
            if ((next = this.currentBase.next()) == null) {
                this.currentBase = null;
                return this.safeNext();
            }
            return next;
        }

        @Override
        public void reset() {
            this.memberSet.reset();
            this.currentBase = null;
        }

        @Override
        public OlapIterator<OlapMember> newInstance() {
            return new ExpandIterator(this.memberSet, this.memberFilter);
        }

        @Override
        @Nullable
        public OlapTupleDimensionality getTupleDimensionality() {
            return this.memberSet.getTupleDimensionality();
        }

        @Override
        public boolean mightHaveCalcMember() {
            return this.memberSet.mightHaveCalcMember();
        }
    }

    private static class ExpandTupleIterator
    extends OlapBaseIterator<OlapTuple> {
        private final OlapIterator<? extends OlapTuple> iterator;
        private final OlapFastCrossjoinContext cjContext;
        private final OlapTupleFilter tupleFilter;
        private final OlapMemberFilter memberFilter;
        private OlapBaseIterator<OlapTuple> currentTupleIter;

        public ExpandTupleIterator(OlapIterator<? extends OlapTuple> iterator, OlapMemberFilter filter, OlapTupleFilter tupleFilter, OlapFastCrossjoinContext cjContext) {
            this.iterator = iterator;
            this.tupleFilter = tupleFilter;
            this.memberFilter = filter;
            this.cjContext = cjContext;
        }

        @Override
        @Nullable
        protected OlapTuple safeNext() {
            if (this.currentTupleIter == null) {
                this.currentTupleIter = this.nextTupleIter();
            }
            if (this.currentTupleIter == null) {
                return null;
            }
            OlapTuple next = this.currentTupleIter.next();
            if (next == null) {
                this.currentTupleIter = null;
                return this.safeNext();
            }
            return next;
        }

        private OlapBaseIterator<OlapTuple> nextTupleIter() {
            OlapTuple tuple = this.iterator.next();
            if (tuple == null) {
                return null;
            }
            ArrayList tupleAsSet = new ArrayList();
            tuple.forEach(member -> tupleAsSet.add(OlapSetFactory.instance((OlapTuple[])new OlapTuple[]{member})), m -> true);
            OlapFastCrossjoinIterator cj = new OlapFastCrossjoinIterator(this.cjContext, tupleAsSet, this.tupleFilter);
            return cj.decorateMemberCrossjoin(m -> new ExpandIterator((OlapIterator<OlapMember>)m, this.memberFilter));
        }

        @Override
        public void reset() {
            this.iterator.reset();
            this.currentTupleIter = null;
        }

        @Override
        public OlapIterator<OlapTuple> newInstance() {
            return new ExpandTupleIterator(this.iterator.newInstance(), this.memberFilter, this.tupleFilter, this.cjContext);
        }

        @Override
        @Nullable
        public OlapTupleDimensionality getTupleDimensionality() {
            return this.iterator.getTupleDimensionality();
        }

        @Override
        public boolean mightHaveCalcMember() {
            return this.iterator.mightHaveCalcMember();
        }
    }
}

