/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OlapCrossjoinFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Crossjoin";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE);

    public OlapCrossjoinFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        List<OlapTupleSet<?>> argsAsSets = this.evalArgumentsAsSets(context, args);
        if (argsAsSets.isEmpty()) {
            return OlapCrossjoinFunction.asNull();
        }
        if (argsAsSets.size() <= 1) {
            return (OlapNonScalarEntity)this.onFunctionError(args.getErrorContext(context), OlapErrorCode.UNEXPECTED_SET_COUNT, new Serializable[0]);
        }
        OlapIterator<OlapTuple> iterator = OlapIteratorFactory.crossjoin(context, args, true, argsAsSets);
        return OlapSetFactory.instance(iterator);
    }

    private List<OlapTupleSet<?>> evalArgumentsAsSets(GFContext context, GFFunctionArgs args) {
        ArrayList argsAsSets = new ArrayList();
        for (int idx = 0; idx < args.size(); ++idx) {
            if (args.isMissingArg(idx)) continue;
            OlapTupleSet<? extends OlapTuple> set = args.toSet(context, idx, true);
            argsAsSets.add(set);
        }
        return argsAsSets;
    }
}

