/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapSortedVTuples;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFTopLikeApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.set.OlapBoundedSortedTuplesFunction;
import java.io.Serializable;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public abstract class OlapCountBoundedSortedTuplesFunction
extends OlapBoundedSortedTuplesFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 4){

        @Override
        public boolean isLambda(int pos) {
            return pos == 2;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapCountBoundedSortedTuplesFunction(String name) {
        super(name, ARGS);
    }

    protected abstract OlapNonScalarEntity doEvalWithNoSorting(OlapTupleSet var1, int var2);

    protected abstract OlapSortedVTuples createSortedTuples(GFContext var1, Comparator<String> var2, int var3, boolean var4);

    @Override
    @Nullable
    protected OlapSortedVTuples createSortedTuplesForCluster(GFContext context, GFFunctionArgs args, GFTopLikeApplyLambdaNode arg) {
        int n = arg.getEvaluatedCount(context, args);
        if (n > 0) {
            boolean excludeEmpty = OlapCountBoundedSortedTuplesFunction.isExcludeEmpty(context, args);
            return this.createSortedTuples(context, context.getSchema().getLocalizedStringComparator(), n, excludeEmpty);
        }
        return null;
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        if (args.size() != 2) {
            throw new RuntimeException("internal error: " + this.getName() + "() : unexpected argument count [" + args.size() + "]");
        }
        int count = args.toInteger(context, 1);
        if (count < 0) {
            return (OlapNonScalarEntity)args.onFunctionError(context, 1, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"count", Integer.valueOf(count), ">= 0"});
        }
        if (count == 0) {
            return OlapSetFactory.empty();
        }
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0, true);
        if (set == null) {
            return OlapSetFactory.empty();
        }
        return this.doEvalWithNoSorting(set, count);
    }
}

