/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorTransform;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBaseTupleTransformFunction
extends OlapNonScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, Integer.MAX_VALUE){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapBaseTupleTransformFunction(String name) {
        super(name, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet<? extends OlapTuple> tuples = args.toSet(context, 0);
        HashSet<OlapHierarchy> hierarchies = new HashSet<OlapHierarchy>(args.size());
        for (int ii = 1; ii < args.size(); ++ii) {
            OlapHierarchy hierarchy = args.toHierarchyX(context, ii, false);
            hierarchies.add(hierarchy);
        }
        IOlapEvaluationExceptionContext errContext = args.getErrorContext(context).snapshotForError();
        OlapTupleDimensionalityCache cache = args.getTupleDimensionalityCache(context);
        OlapTupleFilter tupleFilter = args.getTupleFilter(context);
        MyTransform transform = this.createTupleTransform(hierarchies, errContext, cache, tupleFilter);
        OlapIterator iterator = tuples.getIterator(false);
        OlapIterator<OlapTuple> extract = OlapIteratorFactory.transform(iterator, transform);
        return OlapSetFactory.instance(OlapIteratorFactory.distinct(extract));
    }

    protected abstract MyTransform createTupleTransform(Set<OlapHierarchy> var1, IOlapEvaluationExceptionContext var2, OlapTupleDimensionalityCache var3, @Nullable OlapTupleFilter var4);

    protected abstract class MyTransform
    extends OlapIteratorTransform<OlapTuple, OlapTuple> {
        protected final IOlapEvaluationExceptionContext errContext;
        protected final OlapTupleDimensionalityCache cache;
        protected final Set<OlapHierarchy> hierarchies;
        protected final OlapTupleDimensionality hierarchiesD;
        @Nullable
        protected final OlapTupleFilter tupleFilter;
        final /* synthetic */ OlapBaseTupleTransformFunction this$0;

        public MyTransform(OlapBaseTupleTransformFunction this$0, IOlapEvaluationExceptionContext errContext, OlapTupleDimensionalityCache cache, @Nullable Set<OlapHierarchy> hierarchies, OlapTupleFilter tupleFilter) {
            OlapBaseTupleTransformFunction olapBaseTupleTransformFunction = this$0;
            Objects.requireNonNull(olapBaseTupleTransformFunction);
            this.this$0 = olapBaseTupleTransformFunction;
            this.errContext = errContext;
            this.cache = cache;
            this.hierarchies = hierarchies;
            this.tupleFilter = tupleFilter;
            OlapBitSet set = new OlapBitSet();
            for (OlapHierarchy hierarchy : hierarchies) {
                set.set(hierarchy.getTupleDimensionalityIndex());
            }
            this.hierarchiesD = new OlapTupleDimensionality(set);
        }

        @Override
        public boolean isTransformingDimensionality() {
            return true;
        }

        @Override
        public OlapTuple transform(OlapTuple tuple) {
            OlapTuple ret = this.transformTuple(tuple);
            if (ret != null) {
                if (ret.isKO()) {
                    return null;
                }
                return ret;
            }
            return this.onError(tuple);
        }

        protected abstract OlapTuple transformTuple(OlapTuple var1);

        protected OlapTuple onError(OlapTuple tuple) {
            ArrayList set = new ArrayList();
            CdCollections.complement(tuple.getTupleHierarchies(), this.hierarchies, set);
            String pa = Arrays.toString(set.toArray());
            return (OlapTuple)this.this$0.onFunctionError(this.errContext, OlapErrorCode.EXTRACT_MISSING_HIERARCHY, new Serializable[]{pa});
        }
    }
}

