/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;

public abstract class OlapBaseTimePeriodsToDateFunction
extends OlapMdxTimeNavigationFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, 1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapBaseTimePeriodsToDateFunction(String name, OlapFunctionArgs arguments) {
        super(name, arguments);
    }

    protected abstract OlapLevelType getLevelType();

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member;
        OlapLevelType levelType;
        OlapHierarchy timeHierarchy = args.getDefaultTimeHierarchy(context);
        if (timeHierarchy == null) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_DEFAULT_HIERARCHY, new Serializable[]{args.getUnderlyingCubeName(context)});
        }
        IOlapHierarchyPermission permissions = args.getHierarchyPermissionsWithoutPerspective(context, timeHierarchy);
        OlapLevel level = timeHierarchy.getLevel(permissions, levelType = this.getLevelType());
        if (level == null) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_LEVEL, new Serializable[]{levelType.getName(), timeHierarchy.getUniqueName(args.getNameContext(context)), args.getUnderlyingCubeName(context)});
        }
        if (args.isMissingArg(0)) {
            member = args.getNullableCurrentMember(context, timeHierarchy);
            if (member == null) {
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_CURRENT_MEMBER, new Serializable[]{timeHierarchy.getUniqueName(args.getNameContext(context)), args.getUnderlyingCubeName(context)});
            }
        } else {
            OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member");
            if (arg0.isMdxNull()) {
                return OlapSetFactory.empty();
            }
            member = args.toMember(context, 0);
        }
        this.assertSameHierarchy(args.getErrorContext(context), level, member);
        return member.periodsToDate(args.getMemberFilter(context), level);
    }
}

