/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractDrilldownLevelFunction
extends OlapMdxNavigationFunction {
    public OlapAbstractDrilldownLevelFunction(String name, OlapFunctionArgs args) {
        super(name, args);
    }

    @Nullable
    public OlapLevel getLowestLevel(IOlapEvaluationExceptionContext context, OlapTupleSet<? extends OlapTuple> set, int pos) {
        OlapTuple tuple;
        OlapLevel lowestLevel = null;
        OlapIterator tuples = set.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            if (pos < 0) {
                return (OlapLevel)this.onFunctionError(context, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"hierarchy/member index", Integer.valueOf(pos), ">= 0"});
            }
            if (pos >= tuple.getMemberCount()) break;
            OlapMember member = tuple.getMember(pos);
            if (lowestLevel != null && member.getLevel().getDepth() <= lowestLevel.getDepth()) continue;
            lowestLevel = member.getLevel();
        }
        return lowestLevel;
    }

    @Nullable
    protected OlapLevel getLowestLevel(GFContext context, GFFunctionArgs args, OlapTupleSet<? extends OlapTuple> set, int pos) {
        OlapTuple tuple;
        OlapLevel lowestLevel = null;
        OlapIterator tuples = set.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            if (pos < 0) {
                return (OlapLevel)args.onFunctionError(context, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"hierarchy/member index", Integer.valueOf(pos), ">= 0"});
            }
            if (pos >= tuple.getMemberCount()) break;
            OlapMember member = tuple.getMember(pos);
            if (lowestLevel != null && member.getLevel().getDepth() <= lowestLevel.getDepth()) continue;
            lowestLevel = member.getLevel();
        }
        return lowestLevel;
    }

    protected OlapNonScalarEntity doEvalForLevel(GFContext context, GFFunctionArgs args, OlapTupleSet<? extends OlapTuple> set, @Nullable OlapLevel level, int count) {
        OlapTuple tuple;
        if (level == null) {
            return set;
        }
        int drilldownHierarchyPos = -1;
        ArrayList<OlapTuple> drilldown = new ArrayList<OlapTuple>();
        OlapIterator tuples = set.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            if (drilldownHierarchyPos == -1 && (drilldownHierarchyPos = tuple.getMemberPos(level.getHierarchy())) == -1) {
                OlapNameContext nameContext = args.getNameContext(context);
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.DRILLDOWN_INVALID_HIERARCHY, new Serializable[]{level.getHierarchy().getUniqueName(nameContext)});
            }
            drilldown.add(tuple);
            OlapMember member = tuple.getMember(drilldownHierarchyPos);
            if (!member.getLevel().equals(level)) continue;
            OlapTupleSet<? extends OlapTuple> children = tuple.drilldown(args.getMemberFilter(context), args.getTupleFilter(context), drilldownHierarchyPos);
            this.addChildren(args, drilldown, children, count);
        }
        return drilldown.isEmpty() ? set : OlapSetFactory.instance(drilldown);
    }

    protected abstract void addChildren(GFFunctionArgs var1, List<OlapTuple> var2, OlapTupleSet<? extends OlapTuple> var3, int var4);
}

