/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.others;

import crazydev.common.mdx.CdMdxColorUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.awt.Color;
import java.io.Serializable;

public class OlapRgbFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "RGB";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: 
                case 1: 
                case 2: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapRgbFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        if (args.size() == 1) {
            return this.evalForString(context, args);
        }
        if (args.size() == 3) {
            return this.evalForIntegers(context, args);
        }
        return (OlapScalarEntity)args.onFunctionArgSizeError(context);
    }

    protected OlapScalarEntity evalForString(GFContext context, GFFunctionArgs args) {
        Object value = args.toString(context, 0, true);
        if (value == null) {
            return OlapRgbFunction.asEmpty();
        }
        int length = ((String)(value = ((String)value).trim())).length();
        if (length != 4 && length != 7) {
            return (OlapScalarEntity)args.onFunctionError(context, OlapErrorCode.RGB_INVALID_VALUE, new Serializable[]{value});
        }
        try {
            if (length == 4) {
                value = ((String)value).substring(0, 2) + ((String)value).charAt(1) + ((String)value).charAt(2) + ((String)value).charAt(2) + ((String)value).charAt(3) + ((String)value).charAt(3);
            }
            Color c = Color.decode((String)value);
            int rgb = CdMdxColorUtils.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
            return new OlapNumericEntity(rgb);
        }
        catch (NumberFormatException ex) {
            return (OlapScalarEntity)args.onFunctionError(context, OlapErrorCode.RGB_INVALID_VALUE, new Serializable[]{value});
        }
    }

    protected OlapScalarEntity evalForIntegers(GFContext context, GFFunctionArgs args) {
        int r = args.toInteger(context, 0);
        int g = args.toInteger(context, 1);
        int b = args.toInteger(context, 2);
        int rgb = CdMdxColorUtils.rgb((int)r, (int)g, (int)b);
        return new OlapNumericEntity(rgb);
    }
}

