/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapPatternStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapMultiArgFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.literal.OlapPatternLiteralInstr;
import crazydev.iccube.olap.eval.literal.OlapStringLiteralInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nullable;

public class OlapPatternMatchesFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "PatternMatches";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: 
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapPatternMatchesFunction() {
        super(NAME, ARGS);
    }

    @Override
    @Nullable
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
        try {
            if (args.length == 2 && args[0] instanceof OlapStringLiteralInstr) {
                Pattern regexp = Pattern.compile(((OlapStringLiteralInstr)args[0]).getValue().value());
                OlapPatternLiteralInstr regexpI = new OlapPatternLiteralInstr(args[0].getLocationRange(), regexp);
                OlapInstr[] argsN = new OlapInstr[]{regexpI, args[1]};
                return new OlapMultiArgFunctionCallInstr(location, mdxNotation, this, argsN);
            }
        }
        catch (PatternSyntaxException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not optimize PatternMatches()", (Throwable)ex);
            throw new OlapEvaluationException(location, OlapErrorCode.REGEX_ERROR, new Serializable[]{ex.getMessage()});
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not optimize PatternMatches()", (Throwable)ex);
        }
        return super.asInstr(context, location, mdxNotation, args);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "string");
        if (arg0 instanceof OlapPatternStringEntity) {
            return this.evalForClusterP(context, args, ((OlapPatternStringEntity)arg0).getPattern());
        }
        String regexp = args.toString(context, 0);
        String value = args.toString(context, 1);
        try {
            boolean matches = value.matches(regexp);
            return OlapBooleanEntity.value(matches);
        }
        catch (PatternSyntaxException ex) {
            throw new OlapEvaluationException(context.getErrorLocation(), OlapErrorCode.REGEX_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    protected OlapScalarEntity evalForClusterP(GFContext context, GFFunctionArgs args, Pattern regexp) {
        String value = args.toString(context, 1);
        boolean matches = regexp.matcher(value).matches();
        return OlapBooleanEntity.value(matches);
    }
}

