/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.scalar.OlapListScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFUnexpectedTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapGetPropertyUniqueValuesFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "GetPropertyUniqueValues";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 4){

        @Override
        public boolean isLambda(int pos) {
            return pos == 2;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: 
                case 3: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapGetPropertyUniqueValuesFunction() {
        super(NAME, ARGS);
    }

    protected OlapGetPropertyUniqueValuesFunction(String name, OlapFunctionArgs args) {
        super(name, args);
    }

    @Override
    public OlapScalarEntity<?> evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0);
        OlapTupleSet<OlapMember> members = set.asMemberSet();
        if (members == null) {
            return new OlapListScalarEntity(new ArrayList());
        }
        String property = args.toString(context, 1);
        Predicate<OlapScalarEntity<?>> predicate = this.getPredicate(context, args);
        int limit = args.size() == 4 ? args.toNumeric(context, 3).intValue() : -1;
        try {
            LinkedHashSet<OlapScalarEntity<?>> uniques = this.evalPropertyUniqueValues(context, members.getIterator(false), property, predicate, limit);
            return new OlapListScalarEntity(uniques);
        }
        catch (GFUnexpectedTupleEvaluator.UnexpectedTupleEvaluationException ex) {
            return (OlapScalarEntity)this.onFunctionError(context, OlapErrorCode.UNEXPECTED_TUPLE_EVALUATION, new Serializable[0]);
        }
    }

    @Nullable
    private Predicate<OlapScalarEntity<?>> getPredicate(GFContext context, GFFunctionArgs args) {
        GFNode predicate;
        GFNode gFNode = predicate = !args.isMissingArg(2) ? args.getArg(2) : null;
        if (predicate == null) {
            return null;
        }
        return value -> {
            context.pushCurrentValue((OlapScalarEntity<?>)value);
            try {
                OlapEntity expr = predicate.execute(context, GFUnexpectedTupleEvaluator.INSTANCE);
                if (expr.isMdxNull()) {
                    boolean bl = false;
                    return bl;
                }
                if (expr instanceof OlapScalarEntity) {
                    boolean bl = OlapScalarOperators.isTrue((OlapScalarEntity)expr);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                context.popCurrentValue();
            }
        };
    }

    private LinkedHashSet<OlapScalarEntity<?>> evalPropertyUniqueValues(GFContext context, OlapIterator<OlapMember> members, String propertyName, @Nullable Predicate<OlapScalarEntity<?>> predicate, int limit) {
        OlapMember member;
        OlapMemberPropertyEvalContext pContext = context.getMemberPropertyEvalContext();
        OlapLevel level = null;
        OlapMemberProperty property = null;
        LinkedHashSet<OlapScalarEntity> uniqueValues = new LinkedHashSet<OlapScalarEntity>();
        LinkedHashSet acceptedValues = new LinkedHashSet();
        int count = 0;
        members.reset();
        while ((member = members.next()) != null) {
            if (count == 0) {
                level = member.getLevel();
                OlapMemberPropertyManager propManager = context.getMemberPropertyManager();
                OlapMemberFilter memberFilter = context.getSchemaPermissionsMemberFilter();
                if (memberFilter != null && !memberFilter.isAccepting(propertyName, level)) {
                    return new LinkedHashSet();
                }
                property = propManager.getProperty(level, propertyName);
                if (property == null) {
                    return (LinkedHashSet)this.onFunctionError(context, OlapErrorCode.PROPERTY_NOT_FOUND, new Serializable[]{propertyName, level.getUniqueName(context.getNameContext())});
                }
                int maxCount = property.evalUniqueMaxValueCount();
                if (maxCount != -1) {
                    limit = limit == -1 ? maxCount : Math.min(maxCount, limit);
                }
            }
            if (++count % 250 == 0 && context.isCancelling()) break;
            OlapScalarEntity value = property.eval(pContext, member);
            if (uniqueValues.contains(value)) continue;
            uniqueValues.add(value);
            if (predicate != null && !predicate.test(value)) continue;
            acceptedValues.add(value);
            if (limit == -1 || acceptedValues.size() < limit) continue;
            break;
        }
        return acceptedValues;
    }
}

