/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.properties.OlapDurationFormatter;
import crazydev.iccube.olap.entity.properties.OlapFormatter;
import crazydev.iccube.olap.entity.properties.OlapFormatterKey;
import crazydev.iccube.olap.entity.scalar.OlapFormatterStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class OlapFormatterFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: 
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };
    private static final Map<String, Method> formatterFactories = new HashMap<String, Method>();

    public OlapFormatterFunction() {
        super("formatter", new OlapFunctionArgs(2));
    }

    @Override
    public String getDescription() {
        return "Create a formatter to use with the FORMAT_STRING property.";
    }

    @Override
    public String getParametersDescription() {
        return "\u00abString Expression\u00bb, \u00abString Expression\u00bb";
    }

    @Override
    public String getMdxGroupName() {
        return "Value Formatter";
    }

    @Override
    public OlapFormatterStringEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        String formatterName = args.toString(context, 0);
        String pattern = args.toString(context, 1);
        OlapFormatterKey key = new OlapFormatterKey(formatterName, args.getLocale(context), pattern);
        OlapFormatter formatter = (OlapFormatter)args.getStatementCachedObject(context, key);
        if (formatter == null) {
            try {
                Method formatterFactory = formatterFactories.get(formatterName);
                formatter = (OlapFormatter)formatterFactory.invoke(null, args.getLocale(context), pattern);
                args.addStatementCachedObject(context, key, formatter);
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException ex) {
                return (OlapFormatterStringEntity)args.onFunctionError(context, OlapErrorCode.CELL_FORMATTER_CREATION_ERROR, new Serializable[]{formatterName, ex.getMessage()});
            }
        }
        return new OlapFormatterStringEntity(formatter);
    }

    private static void registerFormatter(Class<? extends OlapFormatter> formatterClass) {
        try {
            Field nameField = formatterClass.getField("NAME");
            String name = (String)nameField.get(null);
            if (formatterFactories.containsKey(name)) {
                throw new RuntimeException("Duplicate formatter name '" + name + "'");
            }
            Method factory = formatterClass.getMethod("create", Locale.class, String.class);
            if (!OlapFormatter.class.isAssignableFrom(factory.getReturnType())) {
                throw new RuntimeException("Unexpected init return type '" + formatterClass.getName() + "'");
            }
            formatterFactories.put(name, factory);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new RuntimeException("Formatter (" + formatterClass.getName() + ") error", ex);
        }
    }

    static {
        OlapFormatterFunction.registerFormatter(OlapDurationFormatter.class);
    }
}

