/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.others;

import crazydev.common.collection.CdCPair;
import crazydev.iccube.builder.model.impl.view.javasimple.OlapBuilderSimpleJavaAccessor;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapComparableVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapReadOnlyDataRow;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapFisFxRateFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "FisFxRate";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2);

    public OlapFisFxRateFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int idx;
        OlapScalarEntity ratesVector = args.toValue(context, 0, "scalar");
        if (ratesVector.isEmpty()) {
            return OlapFisFxRateFunction.asEmpty();
        }
        if (!(ratesVector instanceof OlapComparableVectorEntity)) {
            return (OlapScalarEntity)this.onFunctionArgTypeMismatchError(context, 0, "OlapComparableVectorEntity", ratesVector.getClass().getSimpleName());
        }
        OlapComparableVectorEntity fxRates = (OlapComparableVectorEntity)ratesVector;
        if (fxRates.size() == 0) {
            return OlapFisFxRateFunction.asEmpty();
        }
        if (fxRates.sameValues()) {
            idx = 0;
        } else {
            CdCPair cdCPair;
            List<Comparable> vector;
            int ret;
            OlapDimension timeDim = context.getSchema().lookupDimensionByName(OlapNameContext.DEFAULT_VALUES, "Time");
            int dateAsInt = this.getDateAsInt(context, timeDim);
            if (dateAsInt == -1) {
                OlapNumericEntity maxDate = args.toNumeric(context, 1);
                if (maxDate.isEmpty()) {
                    return maxDate;
                }
                dateAsInt = maxDate.intValue();
            }
            idx = (ret = Collections.binarySearch(vector = fxRates.getVector(), cdCPair = new CdCPair((Comparable)Integer.valueOf(dateAsInt), (Comparable)Double.valueOf(0.0)))) >= 0 ? ret : Math.max(0, -ret - 1 - 1);
        }
        return idx < 0 ? OlapFisFxRateFunction.asEmpty() : new OlapNumericEntity((Double)((CdCPair)fxRates.get((int)idx)).snd);
    }

    private int getDateAsInt(GFContext context, OlapDimension timeDim) {
        OlapHierarchy fullHier = timeDim.lookupHierarchyByName(OlapNameContext.DEFAULT_VALUES, "Year - Quarter - Month - Date");
        OlapMember fullMember = this.getCurrentMember(context, fullHier);
        if (fullMember != null && fullMember.getLevel().isLast()) {
            LocalDateTime key = (LocalDateTime)fullMember.getKeyValue();
            return this.dateToInteger(key);
        }
        OlapHierarchy dayHier = timeDim.lookupHierarchyByName(OlapNameContext.DEFAULT_VALUES, "Day");
        @Nullable OlapMember defaultDay = this.getCurrentMember(context, dayHier);
        if (defaultDay != null && defaultDay.getLevel().isLast()) {
            LocalDateTime key = (LocalDateTime)defaultDay.getKeyValue();
            return this.dateToInteger(key);
        }
        OlapHierarchy idHier = timeDim.lookupHierarchyByName(OlapNameContext.DEFAULT_VALUES, "ID");
        OlapMember defaultM = this.getCurrentMember(context, idHier);
        if (defaultM != null && defaultM.getLevel().isLast()) {
            return (Integer)defaultM.getKeyValue();
        }
        return -1;
    }

    private int dateToInteger(LocalDateTime key) {
        return 10000 * key.getYear() + 100 * key.getMonthValue() + key.getDayOfMonth();
    }

    @Nullable
    private OlapMember getCurrentMember(GFContext context, OlapHierarchy hier) {
        return context.getNullableCurrentMember(hier);
    }

    public static class Transform
    implements OlapBuilderSimpleJavaAccessor {
        @Override
        public Comparable<?> getValue(IOlapReadOnlyDataRow row, IOlapColumnDef columnDef, Map cache) {
            if (columnDef.getName().equals("DateAndRate")) {
                return new CdCPair(row.get("RateDate"), row.get("Rate"));
            }
            return row.get(columnDef);
        }
    }
}

