/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric.calculators;

import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;

public abstract class OlapVarianceSinglePassCalculator
implements OlapSetCalculatorOneExpression {
    protected double mean = 0.0;
    protected double M2 = 0.0;
    protected int count = 0;

    public static OlapVarianceSinglePassCalculator create() {
        return new OlapVarianceSinglePassCalculator(){

            @Override
            public double calculate() {
                return 0.0;
            }
        };
    }

    @Override
    public boolean isResultEmpty() {
        return this.count == 0;
    }

    @Override
    public void addValue(double valueX) {
        ++this.count;
        double delta = valueX - this.mean;
        this.mean += delta / (double)this.count;
        this.M2 += delta * (valueX - this.mean);
    }

    protected double calculateVarianceN() {
        double variance = this.M2 / (double)this.count;
        return variance;
    }

    protected double calculateVarianceN_1() {
        if (this.count == 1) {
            return 0.0;
        }
        double variance = this.M2 / (double)(this.count - 1);
        return variance;
    }

    protected double calculateStdDevN() {
        double stdDev = this.count <= 1 ? 0.0 : StrictMath.sqrt(this.calculateVarianceN());
        return stdDev;
    }

    protected double calculateStdDevN_1() {
        double stdDev = this.count <= 1 ? 0.0 : StrictMath.sqrt(this.calculateVarianceN_1());
        return stdDev;
    }
}

