/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric.calculators;

import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.IOlapLinearRegressionSinglePassCalculator;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapCovarianceSinglePassCalculator;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapVarianceSinglePassCalculator;

public abstract class OlapLinearRegressionSinglePassCalculator
implements IOlapLinearRegressionSinglePassCalculator {
    OlapCovarianceSinglePassCalculator covarianceCalc = OlapCovarianceSinglePassCalculator.create();
    OlapVarianceSinglePassCalculator varianceCalcX = OlapVarianceSinglePassCalculator.create();
    OlapVarianceSinglePassCalculator varianceCalcY = OlapVarianceSinglePassCalculator.create();

    public static OlapLinearRegressionSinglePassCalculator create() {
        return new OlapLinearRegressionSinglePassCalculator(){

            @Override
            public double calculate() {
                return 0.0;
            }
        };
    }

    @Override
    public boolean isResultEmpty() {
        return this.varianceCalcX.isResultEmpty();
    }

    @Override
    public void addValue(double valueX, double valueY) {
        this.covarianceCalc.addValue(valueX, valueY);
        this.varianceCalcX.addValue(valueX);
        this.varianceCalcY.addValue(valueY);
    }

    @Override
    public double calculateB() {
        return this.covarianceCalc.calculateCovarianceN() / this.varianceCalcX.calculateVarianceN();
    }

    @Override
    public double calculateA() {
        double meanX = this.covarianceCalc.getMean_x();
        double meanY = this.covarianceCalc.getMean_y();
        double b = this.calculateB();
        return meanY - b * meanX;
    }

    @Override
    public double calculateR2() {
        double covXY = this.covarianceCalc.calculateCovarianceN();
        double sxx = this.varianceCalcX.calculateVarianceN();
        double syy = this.varianceCalcY.calculateVarianceN();
        return covXY * covXY / (sxx * syy);
    }
}

