/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapRankApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFRankApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import org.jetbrains.annotations.Nullable;

public class OlapRankFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "Rank";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        @Override
        public boolean isLambda(int pos) {
            return pos == 2;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapRankFunction() {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        if (2 >= args.length || args[2] == null) {
            return super.doPrepareFunctionCall(context, callInstr, args, pArgs);
        }
        return new OlapRankApplyLambdaPreparedInstr(callInstr, args, (OlapFunction)this, pArgs, Callback::new);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTuple tuple;
        if (!args.isMissingArg(2)) {
            throw new RuntimeException("internal error: inconsistent rank() processing");
        }
        OlapTuple tupleToRank = args.toTuple(context, 0, true);
        if (tupleToRank == null) {
            return new OlapNumericEntity(0L, true);
        }
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 1);
        int rank = 1;
        OlapIterator tuples = set.getIterator(false);
        boolean isEmpty = true;
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            if (tuple.equals(tupleToRank)) {
                return new OlapNumericEntity(rank, true);
            }
            ++rank;
            isEmpty = false;
        }
        return OlapRankFunction.onMissingTuple(isEmpty, () -> (OlapScalarEntity)args.onFunctionArgTypeMismatchError(context, 1, "non-empty-set", "{}"));
    }

    private static OlapScalarEntity onMissingTuple(boolean setIsEmpty, OnError error) {
        if (setIsEmpty) {
            return error.onError();
        }
        return new OlapNumericEntity(0L, true);
    }

    @FunctionalInterface
    private static interface OnError {
        public OlapScalarEntity onError();
    }

    static class Callback
    extends GFApplyLambdaCallback<GFRankApplyLambdaNode> {
        private final Object LOCK = new Object();
        private boolean onBeforeSetBatchEvaluationDone;
        @Nullable
        private OlapTuple tupleToRank;
        private boolean valueToRankNull;
        private double valueToRank;
        private boolean found;
        private boolean isEmpty;
        private int rank;

        Callback(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            super(functionCallInstr, functionCallArgInstrs, function, "numeric_expression");
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.PARALLEL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(GFContext context, OlapTupleSet set, GFRankApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            Object object = this.LOCK;
            synchronized (object) {
                this.onBeforeSetBatchEvaluationDone = false;
                this.tupleToRank = lambdaArg.getTupleToRank(context, args);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBeforeSetBatchEvaluation(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.onBeforeSetBatchEvaluationDone) {
                    return;
                }
                this.onBeforeSetBatchEvaluationDone = true;
                if (this.tupleToRank != null) {
                    OlapScalarEntity val = lambdaTupleEvaluator.evaluateAsScalar(context, miniTupleEvaluator, OlapSetFactory.empty(), this.tupleToRank, -1);
                    if (val.isMdxNull()) {
                        this.valueToRankNull = true;
                        this.valueToRank = 0.0;
                    } else {
                        this.valueToRankNull = false;
                        OlapNumericEntity numeric = (OlapNumericEntity)val;
                        this.valueToRank = numeric.doubleValue();
                    }
                } else {
                    this.valueToRankNull = true;
                    this.valueToRank = 0.0;
                }
                this.found = false;
                this.isEmpty = true;
                this.rank = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBeforeLambdaExecution(GFContext context, OlapTuple iTuple) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.tupleToRank == null || this.valueToRankNull) {
                    return;
                }
                if (iTuple.equals(this.tupleToRank)) {
                    this.found = true;
                }
                this.isEmpty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEmptyValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.tupleToRank == null || this.valueToRankNull) {
                    return;
                }
                this.isEmpty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.tupleToRank == null || this.valueToRankNull) {
                    return;
                }
                if (value instanceof OlapNumericEntity) {
                    double dvalue = ((OlapNumericEntity)value).doubleValue();
                    if (dvalue > this.valueToRank) {
                        ++this.rank;
                    }
                } else {
                    this.onFunctionArgTypeMismatchError(context, 2, "numeric", value.getFriendlyTypeName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OlapEntity onDone(GFContext context) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.tupleToRank == null) {
                    return new OlapNumericEntity(0L, true);
                }
                if (this.valueToRankNull) {
                    return OlapRankFunction.asEmpty();
                }
                if (this.found) {
                    return new OlapNumericEntity(this.rank, true);
                }
                return OlapRankFunction.onMissingTuple(this.isEmpty, () -> (OlapScalarEntity)this.onFunctionArgTypeMismatchError(context, 1, "non-empty-set", "{}"));
            }
        }
    }
}

