/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.exception.OlapCalcMemberStackOverflowEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapUserFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapJavaFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, 1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            return OlapFunctionArgumentType.VALUE;
        }
    };
    private final OlapPluginUserJavaFunction function;
    private final String moduleName;

    public OlapJavaFunction(String moduleName, String name, OlapPluginUserJavaFunction function) {
        super(name, new OlapFunctionArgs(function.getMinArgs(), function.getMaxArgs()));
        this.function = function;
        this.moduleName = moduleName;
    }

    @Override
    public boolean withPostFixedNotation() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.function.getDescription();
    }

    @Override
    public String getParametersDescription() {
        int i;
        StringBuilder params = new StringBuilder();
        for (i = 0; i < this.function.getMinArgs(); ++i) {
            if (i != 0) {
                params.append(", ");
            }
            params.append("\u00abNumeric Expression\u00bb");
        }
        for (i = this.function.getMinArgs(); i < this.function.getMaxArgs(); ++i) {
            params.append("[, \u00abNumeric Expression\u00bb]");
        }
        return params.toString();
    }

    @Override
    public String getMdxGroupName() {
        return "MDX User Functions";
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return this.moduleName;
    }

    public OlapPluginUserJavaFunction getFunction() {
        return this.function;
    }

    @Override
    public String getActualJavaClassName() {
        return this.function.getClass().getName();
    }

    @Override
    @Nullable
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
        OlapInstr instr = this.function.asInstr(context, location, mdxNotation, args);
        if (instr != null) {
            return instr;
        }
        return super.asInstr(context, location, mdxNotation, args);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        if (this.function.getSignatureCount() == 1) {
            return this.eval(context, args, 0);
        }
        for (int signatureIdx = 0; signatureIdx < this.function.getSignatureCount(); ++signatureIdx) {
            if (args.size() != this.function.getParameterCount(signatureIdx)) continue;
            return this.eval(context, args, signatureIdx);
        }
        StringBuilder expected = new StringBuilder();
        for (int signatureIdx = 0; signatureIdx < this.function.getSignatureCount(); ++signatureIdx) {
            if (signatureIdx > 0) {
                expected.append(" or ");
            }
            expected.append(this.function.getParameterCount(signatureIdx));
        }
        throw new OlapUserFunctionEvaluationException(context, args, this, "unexpected number of arguments " + args.size() + " (expect:" + expected.toString() + ")");
    }

    private OlapScalarEntity eval(GFContext context, GFFunctionArgs args, int signaturePos) {
        try {
            Object[] parameters = new Object[args.size()];
            for (int idx = 0; idx < args.size(); ++idx) {
                Object val;
                if (args.isMissingArg(idx)) continue;
                OlapEntity entity = args.getNonMissingArgEntity(context, idx, "?");
                if (entity.isMdxNull()) {
                    val = null;
                } else {
                    OlapScalarEntity scalarEntity = args.toValueIfApplicable(context, idx, "scalar");
                    if (scalarEntity == null) {
                        throw new OlapUserFunctionEvaluationException(context, args, idx, this, "the argument at position [" + idx + "] could not be converted from [" + String.valueOf(entity) + "] to a value (e.g. string, int, double)");
                    }
                    if (scalarEntity.isMdxNull()) {
                        val = null;
                    } else {
                        val = scalarEntity.asJavaNativeValue(this.function.getParameterType(signaturePos, idx));
                        if (val == null && idx < this.function.getMinArgs()) {
                            throw new OlapUserFunctionEvaluationException(context, args, idx, this, "the mandatory argument at position [" + idx + "] could not be converted from [" + String.valueOf(scalarEntity) + "] to [" + String.valueOf(this.function.getParameterType(signaturePos, idx)) + "]");
                        }
                    }
                }
                parameters[idx] = val;
            }
            Object value = this.function.eval(signaturePos, parameters);
            OlapScalarEntity res = this.asScalarEntity(context, args, value);
            return res;
        }
        catch (OlapPluginEvaluationException | RuntimeException ex) {
            OlapUserFunctionEvaluationException ex_;
            Throwable cause;
            if (ex instanceof OlapUserFunctionEvaluationException && (cause = (ex_ = (OlapUserFunctionEvaluationException)((Object)ex)).getCause()) instanceof OlapCalcMemberStackOverflowEvaluationException) {
                throw ex_;
            }
            throw new OlapUserFunctionEvaluationException((Throwable)ex, args.getErrorContext(context), (OlapFunction)this, "unexpected exception [" + ex.getMessage() + "]");
        }
    }

    @Override
    public boolean isUserDefined() {
        return true;
    }

    private OlapScalarEntity asScalarEntity(GFContext context, GFFunctionArgs args, Object ret) {
        if (ret == null) {
            return OlapJavaFunction.asEmpty();
        }
        if (ret instanceof Float) {
            Float aDouble = (Float)ret;
            return new OlapNumericEntity(aDouble.floatValue());
        }
        if (ret instanceof Double) {
            Double aDouble = (Double)ret;
            return new OlapNumericEntity(aDouble);
        }
        if (ret instanceof Integer) {
            Integer integer = (Integer)ret;
            return new OlapNumericEntity(integer.intValue());
        }
        if (ret instanceof Long) {
            Long integer = (Long)ret;
            return new OlapNumericEntity(integer);
        }
        if (ret instanceof Boolean) {
            Boolean aBoolean = (Boolean)ret;
            return OlapBooleanEntity.value(aBoolean);
        }
        if (ret instanceof String) {
            String str = (String)ret;
            return new OlapStringEntity(str);
        }
        if (ret instanceof LocalDate) {
            LocalDate date = (LocalDate)ret;
            return new OlapDateEntity(date);
        }
        if (ret instanceof LocalDateTime) {
            LocalDateTime date = (LocalDateTime)ret;
            return new OlapDateTimeEntity(date);
        }
        throw new OlapUserFunctionEvaluationException(context, args, this, "unexpected type[" + String.valueOf(ret.getClass()) + "] in return value for method [" + this.getName() + "]");
    }
}

