/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapGenericApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapTuplePreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.io.Serializable;
import java.util.Objects;

public class OlapAggregateFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "Aggregate";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapAggregateFunction() {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        OlapFunction evalFunction;
        OlapMeasureMember measure;
        OlapTuplePreparedInstr pTuple;
        OlapTuple tuple;
        OlapPreparedInstr pExpr;
        OlapPreparedInstr pLambda;
        if (pArgs.length == 2 && (pLambda = pArgs[1]) instanceof OlapLambdaPreparedInstr && (pExpr = ((OlapLambdaPreparedInstr)pLambda).getExpr()) instanceof OlapTuplePreparedInstr && (tuple = (pTuple = (OlapTuplePreparedInstr)pExpr).getTuple()) instanceof OlapMeasureMember && !(measure = (OlapMeasureMember)tuple).isMeasureVector() && measure.getHierarchyAggregationType() == OlapAggregationType.DISTINCT_COUNT && (evalFunction = context.lookupRegularFunction("Eval")) != null) {
            return new OlapFunctionCallPreparedInstr(callInstr, args, evalFunction, pArgs);
        }
        return new OlapGenericApplyLambdaPreparedInstr(callInstr, args, this, pArgs, (x$0, x$1, x$2, x$3, x$4) -> new Callback(this, x$0, x$1, x$2, x$3, x$4), -1);
    }

    class Callback
    extends GFApplyLambdaCallback<GFGenericApplyLambdaNode> {
        private Aggregator aggregator;
        final /* synthetic */ OlapAggregateFunction this$0;

        public Callback(OlapAggregateFunction this$0, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            OlapAggregateFunction olapAggregateFunction = this$0;
            Objects.requireNonNull(olapAggregateFunction);
            this.this$0 = olapAggregateFunction;
            super(functionCallInstr, functionCallArgInstrs, function, "logical_expression");
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.SEQUENTIAL;
        }

        @Override
        public void init(GFContext context, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.aggregator = new Aggregator(this.this$0, args);
        }

        @Override
        public void onBeforeLambdaExecution(GFContext context, OlapTuple iTuple) {
            this.aggregator.onBeforeLambdaExecution(context);
        }

        @Override
        public void onAfterLambdaExecution(GFContext context) {
            this.aggregator.onAfterLambdaExecution(context);
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            this.aggregator.aggregate(value);
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            if (this.aggregator.aggregated == null) {
                return OlapAggregateFunction.asEmpty();
            }
            return this.aggregator.aggregated;
        }
    }

    class Aggregator {
        private final GFFunctionArgs args;
        private OlapScalarEntity aggregated;
        private OlapAggregationType atype;
        final /* synthetic */ OlapAggregateFunction this$0;

        public Aggregator(OlapAggregateFunction this$0, GFFunctionArgs args) {
            OlapAggregateFunction olapAggregateFunction = this$0;
            Objects.requireNonNull(olapAggregateFunction);
            this.this$0 = olapAggregateFunction;
            this.args = args;
        }

        void onBeforeLambdaExecution(GFContext context) {
            context.setupAggregationTypeOn();
        }

        void onAfterLambdaExecution(GFContext context) {
            String uname;
            OlapMember member;
            OlapNameContext nameContext;
            OlapAggregationType contextAggrType = context.getAggregationType();
            OlapAggregationType atype = contextAggrType == null ? OlapAggregationType.SUM : contextAggrType;
            if (this.atype != null && this.atype != atype) {
                nameContext = context.getNameContext();
                member = context.getAggregationTypeMember();
                uname = member != null ? member.getUniqueName(nameContext) : "literal-expression";
                this.this$0.onFunctionError(this.args.getErrorContext(context), OlapErrorCode.AGGREGATE_MULTI_TYPE, new Serializable[]{uname, this.atype, atype});
            }
            if (!atype.isMultiTupleSupported()) {
                nameContext = context.getNameContext();
                member = context.getAggregationTypeMember();
                uname = member != null ? member.getUniqueName(nameContext) : "literal-expression";
                this.this$0.onFunctionError(this.args.getErrorContext(context), OlapErrorCode.AGGREGATE_TYPE_NOT_SUPPORTED, new Serializable[]{uname, atype.getFriendlyName()});
            }
            this.atype = atype;
        }

        public void aggregate(OlapScalarEntity value) {
            this.aggregated = OlapAbstractScalarEntity.aggregate(null, null, this.aggregated, value, this.atype);
        }
    }
}

