/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.level;

import crazydev.common.mdx.error.CdMdxException;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.scalar.OlapAbstractStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;

public class OlapLevelsFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "Levels";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapLevelsFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapHierarchy hierarchy = args.toHierarchyX(context, 0, false);
        IOlapHierarchyPermission permissions = args.getHierarchyPermissionsWithoutPerspective(context, hierarchy);
        OlapScalarEntity levelDef = args.toValueIfApplicable(context, 1, "numeric|string");
        if (levelDef instanceof OlapAbstractStringEntity) {
            OlapEntityIdentifier id;
            String name = ((OlapAbstractStringEntity)levelDef).value();
            OlapLevel entity = hierarchy.lookupLevel(args.getNameContext(context), permissions, new OlapEntityIdentifier(name));
            if (entity != null) {
                return entity;
            }
            try {
                id = args.compileIdentifier(context, name);
            }
            catch (CdMdxException ex) {
                return (OlapNonScalarEntity)args.onFunctionError(context, ex);
            }
            entity = hierarchy.lookupLevel(args.getNameContext(context), permissions, id);
            if (entity != null) {
                return entity;
            }
            return OlapNullEntity.INSTANCE;
        }
        if (levelDef instanceof OlapNumericEntity) {
            int index = ((OlapNumericEntity)levelDef).intValue();
            return OlapLevelsFunction.asNullable(hierarchy.lookupLevel(permissions, index));
        }
        OlapEntity arg = args.getNonMissingArgEntity(context, 1, "numeric|string");
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 1, "numeric|string", arg.getFriendlyTypeName());
    }
}

