/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.hierarchy;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import java.util.List;
import java.util.Objects;

public class OlapUnknownMembersFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "UnknownMembers";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1);

    public OlapUnknownMembersFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "hierarchy|dimension");
        if (arg0 instanceof OlapHierarchy) {
            OlapHierarchy hierarchy = (OlapHierarchy)arg0;
            return this.getUnknowns(context, args, hierarchy);
        }
        if (arg0 instanceof OlapDimension) {
            OlapHierarchy hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension)arg0);
            return this.getUnknowns(context, args, hierarchy);
        }
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "hierarchy|dimension", arg0.getFriendlyTypeName());
    }

    private OlapNonScalarEntity getUnknowns(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy) {
        OlapMemberFilter memberFilter = args.getMemberFilter(context);
        List<OlapLevel> levels = hierarchy.getLevels();
        List<OlapMember> unknown = levels.stream().map(OlapLevel::getCreatedUnkownMember).filter(Objects::nonNull).filter(member -> memberFilter == null || memberFilter.isAccepting((OlapMember)member)).toList();
        return OlapSetFactory.instance(unknown);
    }
}

