/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.common;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.IGFStrToFunctionCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;

public abstract class OlapScalarStrToFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        @Override
        public boolean isOption(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapScalarStrToFunction(String name) {
        super(name, ARGS);
    }

    protected abstract String getTargetTypeName();

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        String expr = args.toMdxStringExpression(context, 0);
        if (expr.trim().isEmpty()) {
            return (OlapScalarEntity)this.onFunctionError(args.getErrorContext(context, 0), OlapErrorCode.MDX_EXPRESSION_EXPECTED, new Serializable[0]);
        }
        boolean constrained = false;
        if (!args.isMissingArg(1)) {
            OlapOption ignored = args.toOption(context, 1, OlapOption.CONSTRAINED);
            constrained = true;
        }
        OlapScalarEntity entity = args.executeStrToMdxExpression(context, constrained, this, 0, expr, "str-to-?", this.createStrToCallback(args, 0));
        return entity;
    }

    protected <T> T onStrToFunctionConversionError(GFContext context, GFFunctionArgs args, int argNb, OlapEntity entity) {
        return args.onFunctionArgTypeMismatchError(context, argNb, this.getTargetTypeName(), entity.getFriendlyTypeName());
    }

    protected abstract IGFStrToFunctionCallback<OlapScalarEntity> createStrToCallback(GFFunctionArgs var1, int var2);
}

