/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx;

import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.olap.eval.execinstr.OlapDeclaredFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstrRef;
import crazydev.iccube.olap.eval.function.OlapEntityFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDeclaredFunction
extends OlapEntityFunction {
    private final OlapInstr body;

    public OlapDeclaredFunction(String name, List<OlapDeclaredFunctionParameter> parameters, OlapInstr body) {
        super(name, new OlapDeclaredFunctionArgs(parameters));
        this.body = body;
    }

    public OlapErrorLocation getLocationRange() {
        return this.body.getLocationRange();
    }

    @Override
    public boolean isDeclared() {
        return true;
    }

    public OlapInstr getBody() {
        return this.body;
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        OlapPreparedInstrRef pBodyRef = context.getReference(this.body);
        if (pBodyRef == null) {
            pBodyRef = context.setReference(this.body);
            OlapPreparedInstr pBody = this.body.prepare(context);
            pBodyRef.setReferenced(pBody);
        }
        return this.doPrepareFunctionCall(context, callInstr, args, pArgs, pBodyRef);
    }

    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs, OlapPreparedInstrRef pBodyRef) {
        return new OlapDeclaredFunctionCallPreparedInstr(callInstr, args, this, pArgs, pBodyRef);
    }

    public boolean isNativeJava() {
        return this.body.isNativeJava();
    }

    @Nullable
    public MdxFunctionNativeBodyExpression getNativeFunctionSourceCode() {
        return this.body.getNativeFunctionSourceCode();
    }

    static class OlapDeclaredFunctionArgs
    extends OlapFunctionArgs {
        private final List<OlapDeclaredFunctionParameter> parameters;

        public OlapDeclaredFunctionArgs(List<OlapDeclaredFunctionParameter> parameters) {
            super(parameters.size());
            this.parameters = parameters;
        }

        @Override
        public String getName(int pos) {
            if (pos < 0 || pos >= this.parameters.size()) {
                return super.getName(pos);
            }
            OlapDeclaredFunctionParameter param = this.parameters.get(pos);
            return param.getName();
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            return this.parameters.get(pos).getType();
        }

        @Override
        public String toStringForDebugger() {
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < this.parameters.size(); ++ii) {
                OlapDeclaredFunctionParameter parameter = this.parameters.get(ii);
                if (ii > 0) {
                    sb.append(",");
                }
                sb.append(parameter.getName());
            }
            return sb.toString();
        }
    }
}

