/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapSingleArgFunctionCallInstr
extends OlapFunctionCallInstr {
    private final OlapFunction function;
    protected OlapInstr arg;

    public OlapSingleArgFunctionCallInstr(OlapInstrLocationRange range, OlapFunctionCallInstr.Notation notation, OlapFunction function, OlapInstr arg) {
        super(range, notation, function.getName());
        this.function = function;
        this.setupArg(arg);
    }

    @Override
    public String typeForError() {
        return "FUNCTION CALL";
    }

    @Override
    public boolean isSubCubeXyz() {
        return this.function.isSubCubeXyz();
    }

    private void setupArg(OlapInstr instr) {
        this.arg = instr;
        this.arg.setParent(this);
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    @Override
    public OlapInstr getArg(int pos) {
        if (pos != 0) {
            throw new CdProgrammingException("Missing argument [" + pos + "]");
        }
        return this.arg;
    }

    @Override
    protected OlapFunction resolveFunction(IOlapPrepareContext context) {
        return this.function;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.arg.accept(v);
        }
    }
}

