/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.iccube.collection.OlapITupleList;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFTopLevelAxisEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;

public abstract class OlapNonScalarEntityFunction
extends OlapFunction {
    protected OlapNonScalarEntityFunction(String name, OlapFunctionArgs argsInfo) {
        super(name, argsInfo);
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        throw new RuntimeException("internal error: inconsistent function [" + this.name + "] evaluation");
    }

    public static int prepareLimit(IOlapPrepareContext context, OlapFunctionCallInstr callInstr) {
        int limitFromOuterFunction = OlapNonScalarEntityFunction.prepareLimitFromOuterFunction(callInstr);
        if (limitFromOuterFunction != -1) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s prepared limit from outer function : %s ".formatted(callInstr.getFunctionName(), limitFromOuterFunction));
            return limitFromOuterFunction;
        }
        int limitFromTidyTable = OlapNonScalarEntityFunction.prepareLimitFromTidyTable(context, callInstr);
        if (limitFromTidyTable != -1) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s prepared limit from tidy table : %s ".formatted(callInstr.getFunctionName(), limitFromTidyTable));
        }
        return limitFromTidyTable;
    }

    private static int prepareLimitFromOuterFunction(OlapFunctionCallInstr callInstr) {
        int limit = -1;
        OlapInstr parent = callInstr.getParent();
        if (parent instanceof OlapFunctionCallInstr) {
            OlapFunctionCallInstr parentFC = (OlapFunctionCallInstr)parent;
            limit = parentFC.getLambdaLimit();
        }
        return limit;
    }

    private static int prepareLimitFromTidyTable(IOlapPrepareContext context, OlapFunctionCallInstr callInstr) {
        OlapMdxStatementExecutionContext sContext;
        OlapAxisInstr aInstr;
        OlapInstr pInstr;
        GFTopLevelAxisEvalContext aContext;
        if (context instanceof GFTopLevelAxisEvalContext && (aContext = (GFTopLevelAxisEvalContext)context).getAxisNumber() > 0L && (pInstr = callInstr.getParent()) instanceof OlapAxisInstr && !(aInstr = (OlapAxisInstr)pInstr).hasNonEmptyKeyword() && (sContext = aContext.getStatementExecutionContext()).isForTidyEvaluation()) {
            return sContext.getTidyMaxRowCount();
        }
        return -1;
    }

    public static int actualLimitForInitX(GFContext context, GFFunctionArgs args, OlapITupleList tuples) {
        int limitFromContext = tuples.limit();
        int limitFromArgs = args.size() == 3 ? args.toNumeric(context, 2).intValue() : -1;
        int limit = OlapNonScalarEntityFunction.actualLimit(limitFromContext, limitFromArgs);
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s() actual limit (lambda-evaluation) : %d [context:%d] [args:%d]".formatted(args.getFunction().getName(), limit, limitFromContext, limitFromArgs));
        return limit;
    }

    public static int actualLimit(int limit1, int limit2) {
        if (limit1 == -1 && limit2 == -1) {
            return -1;
        }
        if (limit1 == -1) {
            return limit2;
        }
        if (limit2 == -1) {
            return limit1;
        }
        return Math.min(limit1, limit2);
    }
}

