/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapMultiArgFunctionCallInstr
extends OlapFunctionCallInstr {
    private final OlapFunction function;
    private final OlapInstr[] args;

    public OlapMultiArgFunctionCallInstr(OlapInstrLocationRange range, OlapFunctionCallInstr.Notation notation, OlapFunction function, OlapInstr ... args) {
        super(range, notation, function.getName());
        this.function = function;
        this.args = args;
        for (OlapInstr arg : args) {
            arg.setParent(this);
        }
    }

    @Override
    public String typeForError() {
        return "FUNCTION CALL";
    }

    @Override
    public boolean isSubCubeXyz() {
        return this.function.isSubCubeXyz();
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            for (OlapInstr arg : this.args) {
                arg.accept(v);
            }
        }
    }

    @Override
    public int getArgCount() {
        return this.args.length;
    }

    @Override
    public OlapInstr getArg(int pos) {
        if (pos < 0 || pos >= this.args.length) {
            throw new CdProgrammingException("Missing argument [" + pos + "]");
        }
        return this.args[pos];
    }

    @Override
    public int getLambdaLimit() {
        return this.function.getLambdaLimit(this.args);
    }

    @Override
    protected OlapFunction resolveFunction(IOlapPrepareContext context) {
        return this.function;
    }
}

