/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import java.util.HashMap;
import java.util.Map;

public abstract class OlapFunctionDescriptionRepository {
    private static final Map<String, String> groups = new HashMap<String, String>();
    private static final Map<String, String> parameters = new HashMap<String, String>();
    private static final Map<String, String> descriptions = new HashMap<String, String>();

    private static void register(String name, String mdxGroupName, String parameters, String description) {
        groups.put(name, parameters);
        OlapFunctionDescriptionRepository.parameters.put(name, parameters);
        descriptions.put(name, description);
    }

    public static String getMdxGroupName(String name) {
        String params = groups.get(name);
        return params == null ? "" : params;
    }

    public static String getParameters(String name) {
        String params = parameters.get(name);
        return params == null ? "" : params;
    }

    public static String getDescription(String name) {
        String description = descriptions.get(name);
        return description == null ? "" : description;
    }

    static {
        OlapFunctionDescriptionRepository.register("AddCalculatedMembers", "Set", "\u00abSet\u00bb", "Returns a set generated by adding calculated members to a specified set.");
        OlapFunctionDescriptionRepository.register("Aggregate", "Numeric", "(none)", "Returns a number that is calculated by aggregating over the cells returned by the set expression.");
        OlapFunctionDescriptionRepository.register("AllMembers", "Set", "(none)", "Returns a set containing all members of the level, including calculated members.");
        OlapFunctionDescriptionRepository.register("Ancestor", "Navigation", "\u00abMember\u00bb, \u00abLevel\u00bb", "Returns the ancestor of a member at a specified level.");
        OlapFunctionDescriptionRepository.register("Ancestors", "Navigation", "\u00abMember\u00bb, \u00abDistance\u00bb", "Returns a set of all ancestors of a member at a specific distance above the member in the hierarchy.");
        OlapFunctionDescriptionRepository.register("Ascendants", "Navigation", "\u00abMember\u00bb", "Returns the set of the ascendants of the member.");
        OlapFunctionDescriptionRepository.register("Avg", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the average value of a numeric expression evaluated over a set.");
        OlapFunctionDescriptionRepository.register("Axis", "Metadata", "\u00abNumeric Expression\u00bb", "Returns a set defined in an axis.");
        OlapFunctionDescriptionRepository.register("BottomCount", "Set", "\u00abSet\u00bb, \u00abCount\u00bb[, \u00abNumeric Expression\u00bb]", "Sorts a set in ascending order, and returns the specified number of tuples in the specified set with the lowest values.");
        OlapFunctionDescriptionRepository.register("BottomPercent", "Set", "\u00abSet\u00bb, \u00abPercentage\u00bb, \u00abNumeric Expression\u00bb", "Sorts a set and returns the specified number of bottommost elements whose cumulative total is at least a specified percentage.");
        OlapFunctionDescriptionRepository.register("BottomSum", "Set", "\u00abSet\u00bb, \u00abValue\u00bb, \u00abNumeric Expression\u00bb", "Sorts a set and returns the specified number of bottommost elements whose cumulative total is at least a specified value.");
        OlapFunctionDescriptionRepository.register("Children", "Navigation", "(none)", "Returns the children of a member.");
        OlapFunctionDescriptionRepository.register("Count", "Statistical", "\u00abSet\u00bb[, EXCLUDEEMPTY | INCLUDEEMPTY]", "Returns the number of tuples in a set, optionally including or excluding empty tuples.");
        OlapFunctionDescriptionRepository.register("ClosingPeriod", "Time", "[\u00abLevel\u00bb[, \u00abMember\u00bb] ]", "Returns the last sibling among the descendants of a specified level, optionally at a specified member.");
        OlapFunctionDescriptionRepository.register("Correlation", "Statistical", "\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Returns the correlation of two series evaluated over a set.");
        OlapFunctionDescriptionRepository.register("Cousin", "Navigation", "\u00abMember1\u00bb, \u00abMember2\u00bb", "Returns the child member with the same relative position under a parent member as the specified child member.");
        OlapFunctionDescriptionRepository.register("Covariance", "Statistical", "\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Returns the covariance of two series evaluated over a set, using the biased population formula");
        OlapFunctionDescriptionRepository.register("CovarianceN", "Statistical", "\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Returns the covariance of two series evaluated over a set, using the unbiased population formula");
        OlapFunctionDescriptionRepository.register("Crossjoin", "Set", "\u00abSet1\u00bb, \u00abSet2\u00bb", "Returns the cross product of two sets.");
        OlapFunctionDescriptionRepository.register("Current", "\u00abTuple\u00bb", "(none)", "Returns the current tuple from a set during iteration.");
        OlapFunctionDescriptionRepository.register("CurrentMember", "Navigation", "(none)", "Returns the current member along a hierarchy.");
        OlapFunctionDescriptionRepository.register("DefaultMember", "Navigation", "(none)", "Returns the default member of a hierarchy.");
        OlapFunctionDescriptionRepository.register("Descendants", "Set", "\u00abMember\u00bb[, \u00abLevel\u00bb[, \u00abDesc_flags\u00bb]]", "Returns the set of descendants of a member at a specified level, optionally including or excluding descendants in other levels.");
        OlapFunctionDescriptionRepository.register("Dimension", "Navigation", "(none)", "Returns the hierarchy that contains a specified member, level, or hierarchy.");
        OlapFunctionDescriptionRepository.register("Dimensions", "Navigation", "\u00abString Expression\u00bb", "Returns a hierarchy specified by a numeric or string expression.");
        OlapFunctionDescriptionRepository.register("Distinct", "Set", "\u00abSet\u00bb", "Returns a set, removing duplicate tuples from a specified set.");
        OlapFunctionDescriptionRepository.register("DistinctCount", "Statistical", "\u00abSet\u00bb", "Returns the number of distinct tuples in a set.");
        OlapFunctionDescriptionRepository.register("DrilldownLevelBottom", "UI", "\u00abSet\u00bb, \u00abCount\u00bb[, [\u00abLevel\u00bb][, \u00abNumeric Expression\u00bb] ]", "Drills down the members of a specified count of bottom members of a set, at a specified level, to one level below.");
        OlapFunctionDescriptionRepository.register("DrilldownLevel", "UI", "\u00abSet\u00bb[, \u00abLevel\u00bb ]", "Drills down the members of a set one level below the lowest level represented in the set, or to one level below an optional level of a member represented in the set.");
        OlapFunctionDescriptionRepository.register("DrilldownLevelTop", "UI", "\u00abSet\u00bb, \u00abCount\u00bb[, [\u00abLevel\u00bb][, \u00abNumeric Expression\u00bb] ]", "Drills down a specified count of top members of a set, at a specified level, to one level below.");
        OlapFunctionDescriptionRepository.register("DrilldownMemberBottom", "UI", "\u00abSet1\u00bb, \u00abSet2\u00bb, \u00abCount\u00bb[, [\u00abNumeric Expression\u00bb] [, RECURSIVE] ]", "Drills down the members in a specified set that are present in a second specified set, limiting the result set to a specified number of bottommost members.");
        OlapFunctionDescriptionRepository.register("DrilldownMember", "UI", "\u00abSet1\u00bb, \u00abSet2\u00bb[, RECURSIVE]", "Drills down the members in a specified set that are present in a second specified set.");
        OlapFunctionDescriptionRepository.register("DrilldownMemberTop", "UI", "\u00abSet1\u00bb, \u00abSet2\u00bb, \u00abCount\u00bb[, [\u00abNumeric Expression\u00bb] [, RECURSIVE] ]", "Drills down the members in a specified set that are present in a second specified set, limiting the result set to a specified number of topmost members.");
        OlapFunctionDescriptionRepository.register("Error", "Others", "\u00abValue\u00bb", "Raises an error, optionally providing a specified error message.");
        OlapFunctionDescriptionRepository.register("Except", "Set", "\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL]", "Finds the difference between two sets, optionally retaining duplicates.");
        OlapFunctionDescriptionRepository.register("Exists", "Set", "\u00abSet1\u00bb,\u00abSet2\u00bb[,MeasureGroupName]", "");
        OlapFunctionDescriptionRepository.register("Extract", "Set", "\u00abSet\u00bb, \u00abHierarchy\u00bb", "For all tuples of set filters the members belonging to the hierarchies");
        OlapFunctionDescriptionRepository.register("Filter", "Set", "\u00abSet\u00bb, \u00abSearch Condition\u00bb", "Returns the set resulting from filtering a set based on a search condition.");
        OlapFunctionDescriptionRepository.register("FirstChild", "Navigation", "(none)", "Returns the first child of a specified member.");
        OlapFunctionDescriptionRepository.register("FirstSibling", "Navigation", "(none)", "Returns the first child of the parent of a specified member.");
        OlapFunctionDescriptionRepository.register("Generate", "Set", "(none)", "...");
        OlapFunctionDescriptionRepository.register("Head", "Set", "\u00abSet\u00bb[, \u00abNumeric Expression\u00bb]", "Returns the first specified number of elements in a set.");
        OlapFunctionDescriptionRepository.register("Hierarchize", "Set", "\u00abSet\u00bb[, POST]", "Orders the members of a specified set in a hierarchy in natural or, optionally,post-natural order.");
        OlapFunctionDescriptionRepository.register("Hierarchy", "Metadata", "(none)", "Returns the hierarchy of a specified level.");
        OlapFunctionDescriptionRepository.register("IIf", "Value", "\u00abLogical Expression\u00bb, \u00abobject\u00bb, \u00abobject\u00bb", "Returns one of values determined by a logical test.");
        OlapFunctionDescriptionRepository.register("Intersect", "Set", "\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL]", "Returns the intersection of two sets, optionally retaining duplicates.");
        OlapFunctionDescriptionRepository.register("IsAncestor", "Navigation", "\u00abMember1\u00bb,\u00abMember2\u00bb", "Returns TRUE if a specified member is an ancestor of another specified member, FALSE otherwise.");
        OlapFunctionDescriptionRepository.register("IsEmpty", "Value", "\u00abValue Expression\u00bb", "Returns TRUE if the evaluated expression is the empty cell value, FALSE otherwise.");
        OlapFunctionDescriptionRepository.register("IsError", "Value", "\u00abExpression\u00bb", "Returns whether the evaluated expression is an error.");
        OlapFunctionDescriptionRepository.register("IsGeneration", "Navigation", "\u00abMember_Expression\u00bb,\u00abGeneration_Number\u00bb", "Returns whether a specified member is in a specified generation.");
        OlapFunctionDescriptionRepository.register("IsLeaf", "Navigation", "\u00abMember\u00bb", "Returns TRUE if a specified member is a leaf member, FALSE otherwise.");
        OlapFunctionDescriptionRepository.register("IsSibling", "Navigation", "\u00abMember1\u00bb,\u00abMember2\u00bb", "Returns TRUE if a specified member is a sibling of another specified member, FALSE otherwise.");
        OlapFunctionDescriptionRepository.register("Item", "Others", "(none)", "Returns a member from a specified tuple.");
        OlapFunctionDescriptionRepository.register("Lag", "Navigation", "\u00abNumeric Expression\u00bb", "Returns the member that is a specified number of positions prior to a specified member along the dimension of the member.");
        OlapFunctionDescriptionRepository.register("LastChild", "Metadata", "(none)", "Returns the last child of a specified member.");
        OlapFunctionDescriptionRepository.register("LastPeriods", "Time", "\u00abIndex\u00bb[, \u00abMember\u00bb]", "Returns a set of members prior to and including a specified member.");
        OlapFunctionDescriptionRepository.register("LastSibling", "Navigation", "(none)", "Returns the last child of the parent of a specified member.");
        OlapFunctionDescriptionRepository.register("Lead", "Navigation", "\u00abNumeric Expression\u00bb", "Returns the member that is a specified number of positions following a specified member along the dimension of the member.");
        OlapFunctionDescriptionRepository.register("Level", "Metadata", "(none)", "Returns the level of a member.");
        OlapFunctionDescriptionRepository.register("Levels", "Metadata", "(none)", "Returns the level whose zero-based position in a dimension is specified by a numeric expression.");
        OlapFunctionDescriptionRepository.register("LinRegIntercept", "Statistical", "\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Calculates the linear regression of a set and returns the value of b in the regression line y = ax + b.");
        OlapFunctionDescriptionRepository.register("LinRegPoint", "Statistical", "\u00abNumeric Expression\u00bb, \u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Calculates the linear regression of a set and returns the value of y in the regression line y = ax + b.");
        OlapFunctionDescriptionRepository.register("LinRegR2", "Statistical", "\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Calculates the linear regression of a set and returns R\u00b2 (the coefficient of determination).");
        OlapFunctionDescriptionRepository.register("LinRegSlope", "Statistical", "\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]", "Calculates the linear regression of a set and returns the value of a in the regression line y = ax + b.");
        OlapFunctionDescriptionRepository.register("Max", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the maximum value of a numeric expression evaluated over a set.");
        OlapFunctionDescriptionRepository.register("Median", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the median value of a numeric expression evaluated over a set.");
        OlapFunctionDescriptionRepository.register("MemberToStr", "String", "\u00abMember\u00bb", "Returns a string in Multidimensional Expressions (MDX) format from a member.");
        OlapFunctionDescriptionRepository.register("Members", "Set", "(none)", "Returns the set of all members in a specified hierarchy.");
        OlapFunctionDescriptionRepository.register("Min", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the minimum value of a numeric expression evaluated over a set.");
        OlapFunctionDescriptionRepository.register("Mtd", "Time", "[\u00abMember\u00bb]", "Returns a set of members from the Month level in a Time dimension starting with the first period and ending with a specified member.");
        OlapFunctionDescriptionRepository.register("Name", "Metadata", "(none)", "Applies a set to each member of another set and joins the resulting sets by union.");
        OlapFunctionDescriptionRepository.register("NameToSet", "String", "\u00abMember Name\u00bb", "Returns a set containing a single member based on a string expression containing a member name.");
        OlapFunctionDescriptionRepository.register("NextMember", "Navigation", "(none)", "Returns the next member in the level that contains a specified member.");
        OlapFunctionDescriptionRepository.register("NonEmpty", "Set", "\u00abSet1\u00bb, \u00abSet2\u00bb", "Returns subset of first set with removed empty tuples based on the cross product with a second set.");
        OlapFunctionDescriptionRepository.register("OpeningPeriod", "Time", "[\u00abLevel\u00bb[, \u00abMember\u00bb] ]", "Returns the first sibling among the descendants of a specified level, optionally at a specified member.");
        OlapFunctionDescriptionRepository.register("Order", "Set", "Set\u00bb, {\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb}[, ASC | DESC | BASC | BDESC]", "Arranges the members of a specified set, optionally preserving or breaking the hierarchy.");
        OlapFunctionDescriptionRepository.register("Ordinal", "Metadata", "(none)", "Returns a member from a prior period in the same relative position as a specified member.");
        OlapFunctionDescriptionRepository.register("PeriodsToDate", "Time", "[\u00abLevel\u00bb[, \u00abMember\u00bb] ]", "Returns a set of members (periods) from a specified level starting with the first member and ending with a specified member.");
        OlapFunctionDescriptionRepository.register("ParallelPeriod", "Time", "[\u00abLevel\u00bb[, \u00abNumeric Expression\u00bb[, \u00abMember\u00bb] ] ]", "Returns a member from a prior period in the same relative position as a specified member.");
        OlapFunctionDescriptionRepository.register("Parent", "Navigation", "(none)", "Returns the parent of a specified member.");
        OlapFunctionDescriptionRepository.register("PrevMember", "Navigation", "(none)", "Returns the previous member in the level that contains a specified member.");
        OlapFunctionDescriptionRepository.register("Properties", "Navigation", "\u00abString Expression\u00bb[, TYPED]", "Returns a string containing the value of the specified member property.");
        OlapFunctionDescriptionRepository.register("Qtd", "Time", "[\u00abMember\u00bb]", "Returns a set of sibling members from the same level as a given member, starting with the first sibling and ending with the given member, as constrained by the Quarter level in the Time dimension.");
        OlapFunctionDescriptionRepository.register("Rank", "Statistical", "\u00abTuple\u00bb, \u00abSet\u00bb", "Returns the one-based rank of a specified tuple in a specified set.");
        OlapFunctionDescriptionRepository.register("Root", "\u00abTuple\u00bb", "(none)", "Returns a tuple with ALL members for all hierarchy");
        OlapFunctionDescriptionRepository.register("SetToStr", "String", "\u00abSet\u00bb", "Constructs a string in MDX format from a set.");
        OlapFunctionDescriptionRepository.register("Siblings", "Navigation", "(none)", "Returns the set of siblings of a specified member, including the member itself.");
        OlapFunctionDescriptionRepository.register("Subset", "Set", "\u00abSet\u00bb, \u00abStart\u00bb[, \u00abCount\u00bb]", "Returns a subset of members from a specified set.");
        OlapFunctionDescriptionRepository.register("Sum", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the sum of a numeric expression evaluated over a specified set.");
        OlapFunctionDescriptionRepository.register("Stdev", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the standard deviation of a numeric expression evaluated over a set, using an unbiased population. (Alias for Stdev/Stddev)");
        OlapFunctionDescriptionRepository.register("Stddev", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the standard deviation of a numeric expression evaluated over a set, using an unbiased population. (Alias for Stdev/Stddev)");
        OlapFunctionDescriptionRepository.register("StdevP", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the sample standard deviation of a numeric expression evaluated over a set, using the unbiased population formula (dividing by n). Alias for StdevP/StddevP");
        OlapFunctionDescriptionRepository.register("StddevP", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the sample standard deviation of a numeric expression evaluated over a set, using the unbiased population formula (dividing by n). Alias for StdevP/StddevP");
        OlapFunctionDescriptionRepository.register("StripCalculatedMembers", "Set", "\u00abSet\u00bb", "Returns a set generated by removing calculated members from a specified set.");
        OlapFunctionDescriptionRepository.register("StrToMember", "String", "\u00abString Expression\u00bb", "Returns a member from a string expression in MDX format.");
        OlapFunctionDescriptionRepository.register("StrToSet", "String", "\u00abString Expression\u00bb", "Constructs a set from a specified string expression in MDX format.");
        OlapFunctionDescriptionRepository.register("StrToTuple", "String", "\u00abString Expression\u00bb", "Constructs a tuple from a specified string expression in MDX format.");
        OlapFunctionDescriptionRepository.register("StrToValue", "String", "\u00abString Expression\u00bb", "Returns a value from a string expression.");
        OlapFunctionDescriptionRepository.register("Tail", "Set", "\u00abSet\u00bb[, \u00abCount\u00bb]", "Returns a subset of members from the end of a specified set.");
        OlapFunctionDescriptionRepository.register("TopCount", "Set", "\u00abSet\u00bb, \u00abCount\u00bb[, \u00abNumeric Expression\u00bb]", "Sorts a set in descending order and returns the specified number of elements with the highest values.");
        OlapFunctionDescriptionRepository.register("TopPercent", "Set", "\u00abSet\u00bb, \u00abPercentage\u00bb, \u00abNumeric Expression\u00bb", "Sorts a set and returns the topmost elements whose cumulative total is at least a specified percentage.");
        OlapFunctionDescriptionRepository.register("TopSum", "Set", "\u00abSet\u00bb, \u00abValue\u00bb, \u00abNumeric Expression\u00bb", "Sorts a set and returns the topmost elements whose cumulative total is at least a specified value.");
        OlapFunctionDescriptionRepository.register("TupleToStr", "String", "\u00abTuple\u00bb", "Returns a string in MDX format from a specified tuple.");
        OlapFunctionDescriptionRepository.register("Union", "Set", "\u00abSet1\u00bb, \u00abSet2\u00bb [, ...] [, ALL]", "Returns a set generated by the union of two or more sets, optionally retaining duplicate members.");
        OlapFunctionDescriptionRepository.register("UniqueName", "Metadata", "(none)", "Returns the unique name of a specified hierarchy.");
        OlapFunctionDescriptionRepository.register("Unorder", "Set", "\u00abSet\u00bb", "Returns a set without ordering.");
        OlapFunctionDescriptionRepository.register("UserName", "Others", "(none)", "Returns the domain name and user name of the current connection.");
        OlapFunctionDescriptionRepository.register("VisualTotals", "Statistical", "\u00abSet_Expression\u00bb, \u00abPattern\u00bb", "Returns a set generated by dynamically totaling child members in a specified set, optionally using a pattern for the name of the parent member in the result set.");
        OlapFunctionDescriptionRepository.register("Variance", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the sample variance of a numeric expression evaluated over a set, using the unbiased population formula (dividing by n-1). Alias for Var/Variance");
        OlapFunctionDescriptionRepository.register("Var", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the sample variance of a numeric expression evaluated over a set, using the unbiased population formula (dividing by n-1). Alias for Var/Variance");
        OlapFunctionDescriptionRepository.register("VarianceP", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the variance of a numeric expression evaluated over a set, using a biased population. (Alias for VarP/VarianceP function.)");
        OlapFunctionDescriptionRepository.register("VarP", "Statistical", "\u00abSet Expression\u00bb [, \u00abNumeric Expression\u00bb]", "Returns the variance of a numeric expression evaluated over a set, using a biased population. (Alias for VarP/VarianceP function.)");
        OlapFunctionDescriptionRepository.register("Wtd", "Time", "[\u00abMember\u00bb]", "Returns a set of members from the Week level in a Time dimension starting with the first period and ending with a specified member.");
        OlapFunctionDescriptionRepository.register("Ytd", "Time", "[\u00abMember\u00bb]", "Returns a set of sibling members from the same level as a given member, starting with the first sibling and ending with the given member, as constrained by the Quarter level in the Time dimension.");
    }
}

