/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.filter.dimension;

import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.eval.filter.dimension.OlapMeasureGroupMemberFilterHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OlapDeniedMeasureGroupMemberFilterHelper
extends OlapMeasureGroupMemberFilterHelper {
    private final Map<OlapCube, Set<String>> deniedGroupPerCube = new HashMap<OlapCube, Set<String>>();

    @Override
    public void addAuthorizedMeasureGroups(Set<OlapMeasureGroup> groups) {
        for (OlapMeasureGroup group : groups) {
            this.addMeasureGroup(group, true);
        }
    }

    @Override
    public void addMeasureGroup(OlapMeasureGroup group, boolean authorized) {
        OlapCube cube = group.getCube();
        if (authorized) {
            Set<String> groups = this.deniedGroupPerCube.get(cube);
            if (groups != null) {
                groups.remove(group.getName().toLowerCase());
            }
        } else {
            Set groups = this.deniedGroupPerCube.computeIfAbsent(cube, k -> new HashSet());
            groups.add(group.getName().toLowerCase());
        }
    }

    @Override
    protected boolean isMeasureGroupAuthorized(OlapCube cube, String groupName) {
        Set<String> groups = this.deniedGroupPerCube.get(cube);
        if (groups != null) {
            return !groups.contains(groupName.toLowerCase());
        }
        return true;
    }
}

