/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.filter.dimension;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.eval.filter.dimension.OlapAbstractTupleFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapChainTupleFilter
extends OlapAbstractTupleFilter {
    private final OlapTupleFilter[] filters;

    private OlapChainTupleFilter(List<OlapTupleFilter> filters) {
        this.filters = new OlapTupleFilter[filters.size()];
        for (int idx = 0; idx < filters.size(); ++idx) {
            this.filters[idx] = filters.get(idx);
        }
    }

    @Nullable
    public static OlapChainTupleFilter create(OlapTupleFilter ... filters) {
        if (filters == null) {
            return null;
        }
        ArrayList chain = null;
        for (OlapTupleFilter filter : filters) {
            if (filter == null) continue;
            if (chain == null) {
                chain = new ArrayList();
            }
            filter.addToTupleChain(chain);
        }
        if (chain == null) {
            return null;
        }
        return new OlapChainTupleFilter(chain);
    }

    @Override
    public String getName() {
        return "chain-tuple";
    }

    @Override
    public boolean canFastCrossjoinForNonEmptyProcessing() {
        for (OlapTupleFilter filter : this.filters) {
            if (filter.canFastCrossjoinForNonEmptyProcessing()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFilteringHierarchy(OlapHierarchy hierarchy) {
        for (OlapTupleFilter filter : this.filters) {
            if (!filter.isFilteringHierarchy(hierarchy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addToTupleChain(List<OlapTupleFilter> chain) {
        for (OlapTupleFilter filter : chain) {
            chain.add(filter);
        }
    }

    public int size() {
        return this.filters.length;
    }

    public OlapTupleFilter get(int idx) {
        return this.filters[idx];
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        for (int idx = 0; idx < this.filters.length; ++idx) {
            OlapTupleFilter filter = this.filters[idx];
            if (filter.isAccepting(member)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAccepting(IOlapTuple tuple) {
        for (int idx = 0; idx < this.filters.length; ++idx) {
            OlapTupleFilter filter = this.filters[idx];
            if (filter.isAccepting(tuple)) continue;
            return false;
        }
        return true;
    }
}

