/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.filter.dimension;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.filter.dimension.OlapAbstractMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapChainMemberFilter
extends OlapAbstractMemberFilter {
    private final OlapMemberFilter[] filters;

    private OlapChainMemberFilter(List<OlapMemberFilter> filters) {
        this.filters = new OlapMemberFilter[filters.size()];
        for (int idx = 0; idx < filters.size(); ++idx) {
            this.filters[idx] = filters.get(idx);
        }
    }

    @Override
    public String getName() {
        return "chain-member";
    }

    public int size() {
        return this.filters.length;
    }

    public OlapMemberFilter get(int idx) {
        return this.filters[idx];
    }

    @Nullable
    public static OlapChainMemberFilter create(OlapMemberFilter ... filters) {
        if (filters == null) {
            return null;
        }
        ArrayList chain = null;
        for (OlapMemberFilter filter : filters) {
            if (filter == null) continue;
            if (chain == null) {
                chain = new ArrayList();
            }
            filter.addToMemberChain(chain);
        }
        if (chain == null) {
            return null;
        }
        return new OlapChainMemberFilter(chain);
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        for (int idx = 0; idx < this.filters.length; ++idx) {
            OlapMemberFilter filter = this.filters[idx];
            if (filter.isAccepting(member)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAccepting(OlapLevel level) {
        for (int idx = 0; idx < this.filters.length; ++idx) {
            OlapMemberFilter filter = this.filters[idx];
            if (filter.isAccepting(level)) continue;
            return false;
        }
        return true;
    }

    @Override
    public OlapMember getRedefinedDefaultMember(OlapHierarchy hierarchy) {
        for (int idx = this.filters.length - 1; idx >= 0; --idx) {
            OlapMemberFilter filter = this.filters[idx];
            OlapMember redefinedDefaultMember = filter.getRedefinedDefaultMember(hierarchy);
            if (redefinedDefaultMember == null || !this.isAccepting(redefinedDefaultMember)) continue;
            return redefinedDefaultMember;
        }
        return null;
    }

    @Override
    public void addToMemberChain(List<OlapMemberFilter> chain) {
        for (OlapMemberFilter filter : chain) {
            chain.add(filter);
        }
    }
}

