/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.filter.dimension;

import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.eval.filter.dimension.OlapMeasureGroupMemberFilterHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OlapAuthorizedMeasureGroupMemberFilterHelper
extends OlapMeasureGroupMemberFilterHelper {
    private final Map<OlapCube, Set<String>> authorizedGroupPerCube = new HashMap<OlapCube, Set<String>>();

    @Override
    public void addAuthorizedMeasureGroups(Set<OlapMeasureGroup> groups) {
        for (OlapMeasureGroup group : groups) {
            this.addMeasureGroup(group, true);
        }
    }

    @Override
    public void addMeasureGroup(OlapMeasureGroup group, boolean authorized) {
        OlapCube cube = group.getCube();
        Set groups = this.authorizedGroupPerCube.computeIfAbsent(cube, k -> new HashSet());
        groups.add(group.getName().toLowerCase());
    }

    @Override
    protected boolean isMeasureGroupAuthorized(OlapCube cube, String groupName) {
        Set<String> groups = this.authorizedGroupPerCube.get(cube);
        if (groups != null) {
            return groups.contains(groupName.toLowerCase());
        }
        return false;
    }
}

