/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells.processor;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.collection.olapiterator.OlapCombinationIteratorT;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.collection.olapiterator.cache.OlapCachingIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.facts.cells.processor.IOlapCellProcessor;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellAxis;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellProcessingTidyEvaluation;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapFakeAxis0;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OlapCellProcessorT
extends IOlapCellProcessor {
    private final OlapCellProcessingTidyEvaluation info = new OlapCellProcessingTidyEvaluation();

    protected OlapCellProcessorT(OlapSelectStatementExecutionContext context, boolean isEvalOrdinalOnly, OlapCellAxis[] axes, boolean hasNonEmpty) {
        super(context, isEvalOrdinalOnly, axes, hasNonEmpty);
    }

    @Override
    public IOlapCombinationIterator<OlapTuple> process(IOlapEvalResult result) {
        if (!(result instanceof OlapResMdxTidyTable)) {
            throw new RuntimeException("internal error: unexpected tidy result type");
        }
        OlapResMdxTidyTable tidy = (OlapResMdxTidyTable)result;
        if (!this.hasNonEmpty) {
            if (tidy.isFilter()) {
                return this.processWithoutNonEmptyF(tidy);
            }
            return this.processWithoutNonEmpty(tidy);
        }
        if (tidy.isFilter()) {
            return this.processWithNonEmptyF(tidy);
        }
        return this.processWithNonEmpty(tidy);
    }

    private IOlapCombinationIterator<OlapTuple> processWithoutNonEmptyF(OlapResMdxTidyTable tidy) {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing started [tidy] (filter)");
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing completed [tidy]");
        tidy.init(new OlapFakeAxis0(), null);
        ArrayList iterators = new ArrayList();
        iterators.add(this.axes[0].tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info));
        return new OlapCombinationIteratorT<OlapTuple>(OlapTuple.class, tidy, iterators, null, 1);
    }

    private IOlapCombinationIterator<OlapTuple> processWithoutNonEmpty(OlapResMdxTidyTable tidy) {
        boolean singleMemberAxis = OlapCellProcessorT.isSingleMemberAxis(tidy);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis processing started [tidy] (single-member-axis:" + singleMemberAxis + ")"));
        List[] materializedAxes = new List[this.axes.length];
        for (int ii = 0; ii < this.axes.length; ++ii) {
            OlapCellAxis axis = this.axes[ii];
            if (singleMemberAxis && ii == 1) {
                OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing started [tidy] axis-1 not materialized");
                continue;
            }
            materializedAxes[ii] = axis.materializeForTidyEvaluation(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info, tidy);
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing completed [tidy]");
        if (singleMemberAxis) {
            return this.createCombinationIteratorSMA(tidy, materializedAxes, this.axes[1]);
        }
        return OlapCellProcessorT.createCombinationIterator(tidy, materializedAxes);
    }

    private IOlapCombinationIterator<OlapTuple> processWithNonEmptyF(OlapResMdxTidyTable tidy) {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY started [tidy] (filter)");
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY completed [tidy]");
        tidy.init(new OlapFakeAxis0(), null);
        ArrayList iterators = new ArrayList();
        iterators.add(this.axes[0].tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info));
        return new OlapCombinationIteratorT<OlapTuple>(OlapTuple.class, tidy, iterators, null, 1);
    }

    private IOlapCombinationIterator<OlapTuple> processWithNonEmpty(OlapResMdxTidyTable tidy) {
        List materializedAxis;
        OlapCellAxis axis;
        int ii;
        boolean singleMemberAxis = OlapCellProcessorT.isSingleMemberAxis(tidy);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis processing with NON EMPTY started [tidy] (single-member-axis:" + singleMemberAxis + ")"));
        List[] materializedAxes = new List[this.axes.length];
        int materializedAxisCount = 0;
        for (int ii2 = 0; ii2 < this.axes.length; ++ii2) {
            OlapCellAxis axis2 = this.axes[ii2];
            if (singleMemberAxis && ii2 == 1) {
                OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY [tidy] axis-1 not materialized");
                continue;
            }
            if (!axis2.isFastNonEmpty() && axis2.hasNonEmpty()) {
                materializedAxes[ii2] = axis2.materializeForTidyEvaluation(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info, tidy);
                ++materializedAxisCount;
                continue;
            }
            materializedAxes[ii2] = axis2.materializeForTidyEvaluation(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info, tidy);
            ++materializedAxisCount;
        }
        if (materializedAxisCount == materializedAxes.length) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY completed [tidy] all axes materialized");
            return OlapCellProcessorT.createCombinationIterator(tidy, materializedAxes);
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY still requires lazy evaluation [tidy]");
        if (materializedAxes[0] == null) {
            throw new OlapEvaluationException(this.context, OlapErrorCode.TIDY_AXIS_0_NOT_MATERIALIZED, new Serializable[0]);
        }
        if (tidy.isWithPaging() && materializedAxes[materializedAxes.length - 1] == null) {
            throw new OlapEvaluationException(this.context, OlapErrorCode.TIDY_AXIS_MEASURES_NOT_MATERIALIZED, new Serializable[0]);
        }
        List axis0 = materializedAxes[0];
        List axisPaging = tidy.isWithPaging() ? materializedAxes[materializedAxes.length - 1] : null;
        tidy.init(axis0, axisPaging);
        ArrayList iterators = new ArrayList();
        ArrayList<Integer> iteratorsPOS = new ArrayList<Integer>();
        for (ii = 0; ii < this.axes.length; ++ii) {
            axis = this.axes[ii];
            materializedAxis = materializedAxes[ii];
            if (singleMemberAxis && ii == 1) {
                if (materializedAxis != null) {
                    throw new RuntimeException("internal error: inconsistent single member axis");
                }
                iterators.add(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info));
                iteratorsPOS.add(ii);
                continue;
            }
            if (materializedAxis != null || axis.isCacheUseless()) continue;
            if (iterators.isEmpty()) {
                iterators.add(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info));
                iteratorsPOS.add(ii);
                continue;
            }
            iterators.add(new OlapCachingIterator<OlapTuple>(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info).newInstance()));
            iteratorsPOS.add(ii);
        }
        for (ii = 0; ii < this.axes.length; ++ii) {
            axis = this.axes[ii];
            materializedAxis = materializedAxes[ii];
            if (materializedAxis == axis0 || materializedAxis == axisPaging || singleMemberAxis && ii == 1) continue;
            if (materializedAxis != null) {
                iterators.add(OlapIteratorFactory.instance(materializedAxis));
                iteratorsPOS.add(ii);
                continue;
            }
            if (!axis.isCacheUseless()) continue;
            iterators.add(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info));
            iteratorsPOS.add(ii);
        }
        iterators.add(OlapIteratorFactory.instance(axis0));
        iteratorsPOS.add(0);
        if (axisPaging != null) {
            iterators.add(OlapIteratorFactory.instance(axisPaging));
            iteratorsPOS.add(materializedAxes.length - 1);
        }
        if (iterators.size() != this.axes.length) {
            throw new RuntimeException("internal error: inconsistent axis count [" + iterators.size() + "][" + this.axes.length + "]");
        }
        int rowIteratorsCount = iterators.size() - 1 - (axisPaging != null ? 1 : 0);
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY completed [tidy]");
        return new OlapCombinationIteratorT<OlapTuple>(OlapTuple.class, tidy, iterators, iteratorsPOS, rowIteratorsCount);
    }

    private static OlapCombinationIteratorT<OlapTuple> createCombinationIterator(OlapResMdxTidyTable tidy, List<OlapTuple>[] materializedAxes) {
        tidy.init(materializedAxes[0], tidy.isWithPaging() ? materializedAxes[materializedAxes.length - 1] : null);
        boolean axis0asColumns = tidy.isAxis0asColumns();
        boolean withPaging = tidy.isWithPaging();
        OlapIterator<OlapTuple> axis0 = null;
        OlapIterator<OlapTuple> axisPaging = null;
        ArrayList iterators = new ArrayList();
        ArrayList<Integer> iteratorsPOS = new ArrayList<Integer>();
        for (int axis = 0; axis < materializedAxes.length; ++axis) {
            OlapIterator<OlapTuple> axisIT = OlapIteratorFactory.instance(materializedAxes[axis]);
            if (axis0asColumns && axis == 0) {
                axis0 = axisIT;
                continue;
            }
            if (withPaging && axis == materializedAxes.length - 1) {
                axisPaging = axisIT;
                continue;
            }
            iterators.add(axisIT);
            iteratorsPOS.add(axis);
        }
        if (axis0 != null) {
            iterators.add(axis0);
            iteratorsPOS.add(0);
        }
        if (axisPaging != null) {
            iterators.add(axisPaging);
            iteratorsPOS.add(materializedAxes.length - 1);
        }
        int rowIteratorsCount = iterators.size() - (axis0 != null ? 1 : 0) - (axisPaging != null ? 1 : 0);
        return new OlapCombinationIteratorT<OlapTuple>(OlapTuple.class, tidy, iterators, iteratorsPOS, rowIteratorsCount);
    }

    private IOlapCombinationIterator<OlapTuple> createCombinationIteratorSMA(OlapResMdxTidyTable tidy, List<OlapTuple>[] materializedAxes, OlapCellAxis axis1) {
        List<OlapTuple> axis0 = materializedAxes[0];
        List<OlapTuple> axisPaging = tidy.isWithPaging() ? materializedAxes[materializedAxes.length - 1] : null;
        tidy.init(axis0, axisPaging);
        ArrayList iterators = new ArrayList();
        ArrayList<Integer> iteratorsPOS = new ArrayList<Integer>();
        iterators.add(axis1.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, this.info));
        iteratorsPOS.add(1);
        iterators.add(OlapIteratorFactory.instance(axis0));
        iteratorsPOS.add(0);
        if (axisPaging != null) {
            iterators.add(OlapIteratorFactory.instance(axisPaging));
            iteratorsPOS.add(materializedAxes.length - 1);
        }
        if (iterators.size() != this.axes.length) {
            throw new RuntimeException("internal error: inconsistent axis count");
        }
        int rowIteratorsCount = iterators.size() - 1 - (axisPaging != null ? 1 : 0);
        return new OlapCombinationIteratorT<OlapTuple>(OlapTuple.class, tidy, iterators, iteratorsPOS, rowIteratorsCount);
    }

    private static boolean isSingleMemberAxis(OlapResMdxTidyTable tidy) {
        boolean withPaging = tidy.isWithPaging();
        int axisCount = tidy.getAxisCount();
        return axisCount == 2 && !withPaging || axisCount == 3 && withPaging;
    }
}

