/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells.processor;

import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.collection.olapiterator.OlapCombinationIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.collection.olapiterator.cache.OlapCachingIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellDiagonalIterator;
import crazydev.iccube.olap.eval.facts.cells.processor.IOlapCellProcessor;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellAxis;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;

public class OlapCellProcessor
extends IOlapCellProcessor {
    protected OlapCellProcessor(OlapSelectStatementExecutionContext context, boolean isEvalOrdinalOnly, OlapCellAxis[] axes, boolean hasNonEmpty) {
        super(context, isEvalOrdinalOnly, axes, hasNonEmpty);
    }

    @Override
    public IOlapCombinationIterator<OlapTuple> process(IOlapEvalResult result) {
        if (!this.hasNonEmpty) {
            return this.processWithoutNonEmpty();
        }
        return this.processWithNonEmpty();
    }

    private IOlapCombinationIterator<OlapTuple> processWithoutNonEmpty() {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing started");
        List[] materializedAxes = new List[this.axes.length];
        for (int ii = 0; ii < this.axes.length; ++ii) {
            OlapCellAxis axis = this.axes[ii];
            materializedAxes[ii] = axis.materialize(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, null);
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing completed");
        return this.setupCellTupleCombinationIterator(materializedAxes);
    }

    private IOlapCombinationIterator<OlapTuple> processWithNonEmpty() {
        OlapCellAxis axis;
        int ii;
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY started");
        List[] materializedAxes = new List[this.axes.length];
        int materializedAxisCount = 0;
        for (int ii2 = 0; ii2 < this.axes.length; ++ii2) {
            OlapCellAxis axis2 = this.axes[ii2];
            if (!axis2.isFastNonEmpty() && axis2.hasNonEmpty()) {
                double tupleCount = axis2.fastEstimatedSize();
                int maxSize = this.context.getRequestProperties().getMaxBufferSizeForCachingIterator();
                if (tupleCount == -1.0 || !(tupleCount <= (double)maxSize)) continue;
                materializedAxes[ii2] = axis2.materialize(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, null);
                ++materializedAxisCount;
                continue;
            }
            materializedAxes[ii2] = axis2.materialize(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, null);
            ++materializedAxisCount;
        }
        if (materializedAxisCount == materializedAxes.length) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY completed");
            return this.setupCellTupleCombinationIterator(materializedAxes);
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis processing with NON EMPTY still requires lazy evaluation");
        ArrayList iterators = new ArrayList();
        ArrayList<Integer> iteratorsPOS = new ArrayList<Integer>();
        for (ii = 0; ii < this.axes.length; ++ii) {
            axis = this.axes[ii];
            List materializedAxis = materializedAxes[ii];
            if (materializedAxis != null || axis.isCacheUseless()) continue;
            if (iterators.isEmpty()) {
                iterators.add(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, null));
                iteratorsPOS.add(ii);
                continue;
            }
            iterators.add(new OlapCachingIterator<OlapTuple>(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, null).newInstance()));
            iteratorsPOS.add(ii);
        }
        for (ii = 0; ii < this.axes.length; ++ii) {
            axis = this.axes[ii];
            List materializedAxis = materializedAxes[ii];
            if (materializedAxis != null) {
                iterators.add(OlapIteratorFactory.instance(materializedAxis));
                iteratorsPOS.add(ii);
                continue;
            }
            if (!axis.isCacheUseless()) continue;
            iterators.add(axis.tuples(this.context, this.hasNonEmpty, this.isEvalOrdinalOnly, null));
            iteratorsPOS.add(ii);
        }
        if (iterators.size() != this.axes.length) {
            throw new RuntimeException("internal error: inconsistent axis count");
        }
        return new OlapCombinationIterator<OlapTuple>(OlapTuple.class, iterators, iteratorsPOS);
    }

    private IOlapCombinationIterator<OlapTuple> setupCellTupleCombinationIterator(List<OlapTuple>[] materializedAxes) {
        if (materializedAxes.length == 2 && !materializedAxes[0].isEmpty() && !materializedAxes[1].isEmpty()) {
            return new OlapFactsCellDiagonalIterator<OlapTuple>(OlapTuple.class, materializedAxes[0], materializedAxes[1]);
        }
        ArrayList iterators = new ArrayList();
        for (int axis = 0; axis < materializedAxes.length; ++axis) {
            iterators.add(OlapIteratorFactory.instance(materializedAxes[axis]));
        }
        return new OlapCombinationIterator<OlapTuple>(OlapTuple.class, iterators, null);
    }
}

