/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells.processor;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsRollupSolver;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellMeasureVectorsPositions;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellProcessingTidyEvaluation;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.select.context.OlapCellEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapCellAxis {
    private final int number;
    private final boolean hasNonEmpty;
    private final OlapIterator<OlapTuple> tuples;
    private final boolean fastNonEmpty;
    @Nullable
    private final OlapTupleDimensionality tupleDimensionality;

    public OlapCellAxis(int number, boolean hasNonEmpty, OlapIterator<OlapTuple> tuples, boolean fastNonEmpty, @Nullable OlapTupleDimensionality tupleDimensionality) {
        this.number = number;
        this.hasNonEmpty = hasNonEmpty;
        this.tuples = tuples;
        this.fastNonEmpty = fastNonEmpty;
        this.tupleDimensionality = tupleDimensionality;
    }

    public boolean hasNonEmpty() {
        return this.hasNonEmpty;
    }

    public boolean isFastNonEmpty() {
        return this.fastNonEmpty;
    }

    public double fastEstimatedSize() {
        return this.tuples.fastEstimatedSize();
    }

    public boolean isCacheUseless() {
        return this.tuples.isCacheUseless();
    }

    public OlapIterator<OlapTuple> tuples(OlapSelectStatementExecutionContext context, boolean nonEmptyActive, boolean isEvalOrdinalOnly, @Nullable OlapCellProcessingTidyEvaluation info) {
        return this.wrapTuplesForMeasureVector(context, nonEmptyActive, isEvalOrdinalOnly, info);
    }

    public final List<OlapTuple> materialize(OlapSelectStatementExecutionContext context, boolean nonEmptyActive, boolean isEvalOrdinalOnly, @Nullable OlapCellProcessingTidyEvaluation info) {
        long startMS = System.currentTimeMillis();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") evaluation started " + (this.isFastNonEmpty() ? "( fast NON EMPTY )" : "")));
        List<OlapTuple> materialized = OlapIteratorHelper.extractTuples(this.tuples(context, nonEmptyActive, isEvalOrdinalOnly, info));
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") evaluation done (" + materialized.size() + ") in " + CdTimeUtils.formatMillisEx((long)startMS)));
        return materialized;
    }

    public final List<OlapTuple> materializeForTidyEvaluation(OlapSelectStatementExecutionContext context, boolean nonEmptyActive, boolean isEvalOrdinalOnly, @Nullable OlapCellProcessingTidyEvaluation info, OlapResMdxTidyTable tidy) {
        int limit;
        boolean axisPaging;
        long startMS = System.currentTimeMillis();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + "): evaluation started " + (this.isFastNonEmpty() ? "( fast NON EMPTY )" : "")));
        boolean axis0 = tidy.isAxis0asColumns() && this.number == 0;
        boolean bl = axisPaging = tidy.isWithPaging() && this.number == tidy.getAxisCount() - 1;
        if (axis0 || axisPaging) {
            if (!this.hasNonEmpty) {
                limit = context.getTidyMaxColumnCount();
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + "): materialization: (axis0 | axisPaging) limit:" + limit));
            } else {
                limit = context.getTidyMaxAxisMaterializeCount();
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + "): materialization: (axis0 | axisPaging) (NON EMPTY) limit:" + limit));
            }
        } else if (!this.hasNonEmpty) {
            limit = context.getTidyMaxAxisMaterializeCount();
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + "): materialization: (axisN) limit:" + limit));
        } else {
            limit = context.getTidyMaxAxisMaterializeCount();
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + "): materialization: (axisN) (NON EMPTY) limit:" + limit));
        }
        List<OlapTuple> materialized = OlapIteratorHelper.extractTuplesForAxisTidyMaterialization(context, this.tuples(context, nonEmptyActive, isEvalOrdinalOnly, info), this.number, this.hasNonEmpty, limit);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") evaluation done (" + materialized.size() + ") in " + CdTimeUtils.formatMillisEx((long)startMS)));
        return materialized;
    }

    private OlapIterator<OlapTuple> wrapTuplesForMeasureVector(OlapSelectStatementExecutionContext context, boolean nonEmptyActive, boolean isEvalOrdinalOnly, @Nullable OlapCellProcessingTidyEvaluation info) {
        boolean isMdxEvalMeasureVectorEnabled = context.getRequestProperties().isMdxEvalMeasureVector();
        if (!isMdxEvalMeasureVectorEnabled) {
            return this.tuples;
        }
        if (this.tupleDimensionality == null) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup (dimensionality unknown)"));
            return this.tuples;
        }
        OlapMeasuresDimension measures = context.getMeasuresDimension();
        if (!this.tupleDimensionality.isIn(measures.getHierarchy())) {
            return this.tuples;
        }
        if (this.tupleDimensionality.size() != 1) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup (axis structure not supported)"));
            return this.tuples;
        }
        if (context.isDrillthroughActive()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup (drillthrough)"));
            return this.tuples;
        }
        if (isEvalOrdinalOnly) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup (ordinal-only)"));
            return this.tuples;
        }
        if (context.getInstrExecListener() != null) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup (debugger/profiler)"));
            return this.tuples;
        }
        if (info != null && !info.canWrapTuplesForMeasureVector(this.number)) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup (tidy-evaluation)"));
            return this.tuples;
        }
        List<OlapTuple> measureTuples = OlapIteratorHelper.extractTuplesForMeasures(this.tuples);
        List<OlapTuple> measureVectors = OlapCellAxis.setupMeasureVectors(this.number, measureTuples);
        if (measureVectors == null) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup"));
            return this.tuples;
        }
        OlapCellsEvaluationContext eContext_ = new OlapCellsEvaluationContext(context, nonEmptyActive, Collections.emptyList());
        OlapCellEvaluationContext eContext = new OlapCellEvaluationContext(eContext_);
        OlapTupleFilter tupleFilter = eContext.getTupleFilter();
        if (tupleFilter != null && tupleFilter.isFilteringHierarchy(measures.getHierarchy())) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") ignore measures-vector processing setup ([Measures] filter)"));
            return this.tuples;
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + this.number + ") measures-vector processing enabled"));
        context.setMeasureVectorPositions(new OlapCellMeasureVectorsPositions(measureTuples, measureVectors));
        OlapIterator<OlapTuple> measureVectorsIterator = OlapIteratorFactory.instance(measureVectors);
        return measureVectorsIterator;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static List<OlapTuple> setupMeasureVectors(int axis, List<OlapTuple> measures) {
        OlapMember member;
        int measuresSize = measures.size();
        HashSet<OlapMember> members = new HashSet<OlapMember>();
        boolean hasDuplicates = false;
        for (int ii = 0; ii < measuresSize; ++ii) {
            OlapTuple tuple = measures.get(ii);
            if (tuple.getMemberCount() != 1) {
                return null;
            }
            member = tuple.getMember(0);
            if (!member.isMeasure()) {
                return null;
            }
            if (members.contains(member)) {
                hasDuplicates = true;
            }
            members.add(member);
        }
        if (hasDuplicates) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + axis + ") measures-vector processing not activated (duplicated measures)"));
            return null;
        }
        HashSet<OlapMember> ignoredMeasures = new HashSet<OlapMember>();
        for (int ii = 0; ii < measuresSize; ++ii) {
            member = measures.get(ii).getMember(0);
            if (member.isCalculated()) {
                ignoredMeasures.add(member);
                continue;
            }
            if (member instanceof OlapMeasureMember) {
                OlapMeasureMember measure = (OlapMeasureMember)member;
                OlapAggregationType aggregation = measure.getHierarchyAggregationType();
                if (OlapFactsRollupSolver.isAggregationForMeasureVectorSupported(aggregation) && !measure.hasTableAggregation()) continue;
                ignoredMeasures.add(measure);
                continue;
            }
            return null;
        }
        if (ignoredMeasures.size() == measuresSize) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + axis + ") measures-vector processing not activated (no candidate)"));
            return null;
        }
        HashMap allMeasureGroupMeasures = new HashMap();
        boolean hasMeasureVector = false;
        for (int ii = 0; ii < measuresSize; ++ii) {
            void var10_16;
            OlapMember measure = measures.get(ii).getMember(0);
            if (ignoredMeasures.contains(measure)) continue;
            List list = (List)allMeasureGroupMeasures.get(measure.getMeasureGroupName());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                allMeasureGroupMeasures.put(measure.getMeasureGroupName(), arrayList);
            }
            var10_16.add((OlapMeasureMember)measure);
            if (hasMeasureVector || var10_16.size() <= 1) continue;
            hasMeasureVector = true;
        }
        if (!hasMeasureVector) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + axis + ") measures-vector processing not activated (no vector)"));
            return null;
        }
        ArrayList<OlapTuple> measureVectors = new ArrayList<OlapTuple>();
        for (OlapMember olapMember : ignoredMeasures) {
            measureVectors.add(olapMember);
        }
        for (Map.Entry entry : allMeasureGroupMeasures.entrySet()) {
            List measureGroupMeasures = (List)entry.getValue();
            if (measureGroupMeasures.size() == 1) {
                measureVectors.add((OlapTuple)measureGroupMeasures.get(0));
                continue;
            }
            OlapAggregationType aggrType = OlapAggregationType.SUM;
            measureVectors.add(new OlapMeasureVectorMember(measureGroupMeasures, "MeasuresVector-" + (String)entry.getKey(), aggrType));
        }
        return measureVectors;
    }
}

