/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells;

import crazydev.iccube.common.executor.OlapThreadPoolExecutorServiceListenerAdapter;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskExecutor;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorConfiguration;
import crazydev.iccube.olap.eval.exception.OlapMdxEvaluationCancelled;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellEvaluationTaskFactory;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.executor.OlapMdxCellThreadPoolExecutorService;
import crazydev.iccube.olap.executor.OlapMdxThreadPoolExecutorService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class OlapMdxCellExecutor {
    public static final AtomicInteger UID_GENERATOR = new AtomicInteger();
    private final int uid = UID_GENERATOR.incrementAndGet();
    private final OlapMdxExecutorConfiguration configuration;
    private final int threadCount;
    private final int singleMdxQueueSize;
    @Nullable
    private final OlapMdxThreadPoolExecutorService executorService;

    public OlapMdxCellExecutor(OlapMdxExecutorConfiguration configuration) {
        OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] create executor [" + configuration.getThreadCount() + "][" + configuration.getQueueSize() + "]"));
        this.configuration = configuration;
        this.threadCount = configuration.getThreadCount();
        this.singleMdxQueueSize = configuration.getQueueSize();
        this.executorService = this.threadCount > 0 ? new OlapMdxCellThreadPoolExecutorService(this.threadCount) : null;
    }

    public int getUid() {
        return this.uid;
    }

    public static int getCurrentUid() {
        return UID_GENERATOR.get();
    }

    public OlapMdxExecutorConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getQueuedTaskCount() {
        return this.executorService == null ? -1 : this.executorService.getQueuedTaskCount();
    }

    public void shutdownNow() {
        OlapLoggers.GENERAL.info((Object)"[MDX-CELL] shutdown requested");
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        OlapLoggers.GENERAL.info((Object)"[MDX-CELL] bye");
    }

    public void execute(OlapMdxStatementExecutionContext context, OlapFactsCellEvaluationTaskFactory cellTasks) throws OlapMdxEvaluationCancelled {
        if (this.executorService != null && context.isMultiThreadCellProcessingOk()) {
            this.executeMT(context, cellTasks);
        } else {
            this.executeST(context, cellTasks);
        }
        if (context.isCancelling()) {
            throw new OlapMdxEvaluationCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeST(OlapMdxStatementExecutionContext context, OlapFactsCellEvaluationTaskFactory cellTasks) {
        try {
            IOlapFactsCellEvaluationTask cellTask;
            cellTasks.init();
            while ((cellTask = cellTasks.next()) != null) {
                OlapThreadPoolExecutorTaskExecutor.execute(cellTask);
            }
        }
        finally {
            cellTasks.done();
        }
    }

    private void executeMT(OlapMdxStatementExecutionContext context, OlapFactsCellEvaluationTaskFactory tasks) {
        if (this.executorService == null) {
            throw new RuntimeException("internal error : missing executor service");
        }
        this.executorService.processTasks(context, this.singleMdxQueueSize, tasks, new OlapThreadPoolExecutorServiceListenerAdapter(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void onNextTaskException(RuntimeException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)"MDX eval. unexpected cell task generation exception", (Throwable)ex);
            }
        });
    }
}

