/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation.table;

import crazydev.common.collection.CdAction;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_FactPageColumnLookup;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotationType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.IOlapMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.facts.column.aggregator.ISumAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleNeumaierAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapFactsTableAggregator {
    private final OlapScalarEntityFactColumn[] columns;
    private final TableRow row;
    private final IOlapFactTableAggregator aggregator;

    public OlapFactsTableAggregator(GFContext gfContext, N_FactPage factPage, OlapMeasureMember measure, OlapScalarEntityFactColumn column, IOlapFactTableAggregator aggregator) {
        this.aggregator = aggregator;
        this.row = new TableRow(this);
        N_FactPageColumnLookup lookup = factPage.getLookup();
        this.columns = lookup.getAllColumns();
        aggregator.init(new FactTableContext(gfContext, lookup), measure.getNameX(), column.getId().getFactColumnName());
    }

    public boolean onPoint(int rowNumber) {
        this.row.rowNumber = rowNumber;
        return this.aggregator.onRow(rowNumber, this.row);
    }

    public OlapScalarEntity asScalarEntity() {
        OlapScalarEntity res = this.aggregator.asScalarEntity();
        return res == null ? OlapEmptyEntity.INSTANCE : res;
    }

    public void aggregateFactPage(N_FactPage factPage) {
    }

    private class TableRow
    implements IOlapFactsTableRow {
        int rowNumber;
        final /* synthetic */ OlapFactsTableAggregator this$0;

        private TableRow(OlapFactsTableAggregator olapFactsTableAggregator) {
            OlapFactsTableAggregator olapFactsTableAggregator2 = olapFactsTableAggregator;
            Objects.requireNonNull(olapFactsTableAggregator2);
            this.this$0 = olapFactsTableAggregator2;
            this.rowNumber = -1;
        }

        @Override
        public Comparable getValue(int columnIdx) {
            return this.this$0.columns[columnIdx].getValueAsObject(this.rowNumber);
        }

        @Override
        public String getAggregatorName() {
            return this.this$0.aggregator.getName();
        }

        @Override
        public long getQuickLong(int columnIdx) {
            return this.this$0.columns[columnIdx].getQuickLong(this.rowNumber);
        }

        @Override
        public int getQuickInteger(int columnIdx) {
            return this.this$0.columns[columnIdx].getQuickInteger(this.rowNumber);
        }

        @Override
        public double getQuickDouble(int columnIdx) {
            return this.this$0.columns[columnIdx].getQuickDouble(this.rowNumber);
        }

        @Override
        public float getQuickFloat(int columnIdx) {
            return this.this$0.columns[columnIdx].getQuickFloat(this.rowNumber);
        }

        @Override
        public long getQuickDateTimeMillis(int columnIdx) {
            return this.this$0.columns[columnIdx].getQuickDateTimeMillis(this.rowNumber);
        }

        @Override
        public int getQuickDateMillis(int columnIdx) {
            return this.this$0.columns[columnIdx].getQuickDateMillis(this.rowNumber);
        }
    }

    private static class FactTableContext
    implements IFactTableContext {
        private final GFContext context;
        private final N_FactPageColumnLookup lookup;
        private final ConcurrentHashMap<String, OlapNonScalarEntity> toHierarchy = new ConcurrentHashMap();

        FactTableContext(GFContext context, N_FactPageColumnLookup lookup) {
            this.context = context;
            this.lookup = lookup;
        }

        @Override
        public boolean isDebug() {
            OlapMdxStatementExecutionContext sContext = this.context.getStatementExecutionContext();
            MdxAnnotation[] annotations = sContext.getAnnotations();
            if (annotations != null) {
                for (MdxAnnotation annotation : annotations) {
                    if (annotation.getType() != MdxAnnotationType.DebugTableAggregator) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @Nullable
        public OlapScalarEntity getFromCache(String key) {
            OlapSchema schema = this.context.getSchema();
            return schema.getCacheValue(key);
        }

        @Override
        @Nullable
        public IOlapMember getContextMember(String hierarchyName) {
            OlapHierarchy hier = this.getHierarchy(hierarchyName);
            if (hier == null) {
                throw new RuntimeException("Missing hierarchy [" + hierarchyName + "]");
            }
            List<OlapMember> list = this.context.getContextMembersList(hier);
            return list.size() == 1 ? (IOlapMember)list.getFirst() : null;
        }

        @Override
        public void forEachMember(String dimensionName, String hierarchyName, String levelName, IFactTableContext.MemberAction action) {
            OlapLevel level;
            OlapHierarchy hier;
            OlapSchema schema = this.context.getSchema();
            OlapDimension dim = schema.lookupDimensionByName(OlapNameContext.DEFAULT_VALUES, dimensionName);
            if (dim == null) {
                return;
            }
            OlapHierarchy olapHierarchy = hier = hierarchyName == null ? dim.getBaseHierarchy() : dim.lookupHierarchyByName(OlapNameContext.DEFAULT_VALUES, hierarchyName);
            if (hier == null) {
                return;
            }
            OlapLevel olapLevel = level = levelName == null ? hier.getLastLevel() : hier.getLevels().stream().filter(l -> l.getNameX().equals(levelName)).findFirst().orElseGet(null);
            if (level == null) {
                return;
            }
            level.forEachMember((CdAction<OlapMember>)((CdAction)action::onMember));
        }

        @Override
        public boolean columnNameExists(String columnName) {
            return this.lookup.columnNameExists(columnName);
        }

        @Override
        public int getFromColumnName(String columnName) {
            return this.lookup.getFromColumnName(columnName);
        }

        @Override
        public boolean measureNameExists(String columnName) {
            return this.lookup.measureNameExists(columnName);
        }

        @Override
        public int getFromMeasureName(String measureName) {
            return this.lookup.getFromMeasureName(measureName);
        }

        @Override
        public OlapScalarEntityFactColumn[] getAllColumns() {
            return this.lookup.getAllColumns();
        }

        @Override
        public OlapScalarEntityFactColumn getColumn(Integer coldIdx) {
            return this.lookup.getColumn(coldIdx);
        }

        @Override
        public ISumAggregator hpAggregator() {
            return new OlapFactColumnSumDoubleNeumaierAggregator();
        }

        @Override
        public ISumAggregator defaultAggregator() {
            return OlapFactColumnSumDoubleAggregator.SUM_ALGO.createISum();
        }

        @Nullable
        private OlapHierarchy getHierarchy(String name) {
            if (CdStringUtils.isNullOrBlank((String)name)) {
                return null;
            }
            OlapNonScalarEntity hier = this.toHierarchy.computeIfAbsent(name, hierarchyName -> {
                OlapHierarchy hierarchy;
                int j;
                OlapDimension dimension;
                int i;
                for (i = 0; i < this.context.getSchema().getDimensions().size(); ++i) {
                    dimension = this.context.getSchema().getDimensions().get(i);
                    if (!this.context.getDimensionsPermissions().isDimensionAuthorized(dimension)) continue;
                    for (j = 0; j < dimension.getHierarchies().size(); ++j) {
                        hierarchy = dimension.getHierarchies(this.context.getDimensionsPermissions()).get(j);
                        if (!hierarchyName.equalsIgnoreCase(hierarchy.getName(this.context.getNameContext()))) continue;
                        return hierarchy;
                    }
                }
                for (i = 0; i < this.context.getSchema().getDimensions().size(); ++i) {
                    dimension = this.context.getSchema().getDimensions().get(i);
                    if (!this.context.getDimensionsPermissions().isDimensionAuthorized(dimension)) continue;
                    for (j = 0; j < dimension.getHierarchies().size(); ++j) {
                        hierarchy = dimension.getHierarchies(this.context.getDimensionsPermissions()).get(j);
                        if (!hierarchyName.equalsIgnoreCase(hierarchy.getNameX())) continue;
                        return hierarchy;
                    }
                }
                return OlapNullEntity.INSTANCE;
            });
            return hier == OlapNullEntity.INSTANCE ? null : (OlapHierarchy)hier;
        }

        @Override
        public int getQuickNullInteger() {
            return Integer.MIN_VALUE;
        }

        @Override
        public long getQuickNullLong() {
            return Long.MIN_VALUE;
        }

        @Override
        public double getQuickNullDouble() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public float getQuickNullFloat() {
            return Float.NEGATIVE_INFINITY;
        }
    }
}

