/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation.table;

import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public interface IOlapFactsTableRow {
    public String getAggregatorName();

    public Comparable getValue(int var1);

    public int getQuickInteger(int var1);

    public long getQuickLong(int var1);

    public float getQuickFloat(int var1);

    public double getQuickDouble(int var1);

    public int getQuickDateMillis(int var1);

    public long getQuickDateTimeMillis(int var1);

    default public double getDoubleOrZero(int columnIdx) {
        double v = this.getQuickDouble(columnIdx);
        return v == Double.NEGATIVE_INFINITY ? 0.0 : v;
    }

    @Nullable
    default public Double getAsDouble(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool != false ? 1.0 : 0.0;
        }
        Number number = this.checkType(Number.class, columnIdx, value);
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    @Nullable
    default public Integer getAsInteger(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        Number number = this.checkType(Number.class, columnIdx, value);
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    @Nullable
    default public Long getAsLong(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        Number number = this.checkType(Number.class, columnIdx, value);
        return number == null ? null : Long.valueOf(number.longValue());
    }

    @Nullable
    default public String getAsString(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        return this.checkType(String.class, columnIdx, value);
    }

    @Nullable
    default public LocalDate getAsDate(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        return this.toLocalDate(value);
    }

    @Nullable
    default public LocalDateTime getAsDateTime(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        return this.checkType(LocalDateTime.class, columnIdx, value);
    }

    @Nullable
    default public Boolean getAsBoolean(int columnIdx) {
        Comparable value = this.getValue(columnIdx);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        return (Boolean)this.throwException("Cast exception for column '" + columnIdx + "'. Expected Boolean type got " + value.getClass().getSimpleName());
    }

    default public LocalDate toLocalDate(Comparable value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        return new LocalDate((Object)value);
    }

    default public <T> T checkType(Class<T> type, int columnIdx, Object value) {
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            return this.throwException("Cast exception for column '" + columnIdx + "'. Expected type " + type.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return (T)value;
    }

    default public <T> T throwException(String mess) {
        String tableName = this.getAggregatorName();
        throw new RuntimeException(mess + " in Table Aggregation : '" + tableName + "'");
    }
}

